/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.inaver.url;

import java.util.*;
import javax.servlet.http.*;
import com.aibonware.inaver.model.*;
import com.aibonware.inaver.conv.*;

/**
 * ̐ꂽRg̑}ev[gύX邽
 * EBhE > ݒ > Java > R[h > R[hƃRg
 */
public class BoardUrl extends PageUrl {
	public final int boardId;

	public BoardUrl(HttpServletRequest request, int itemNum) {
		super("board", request, itemNum);

		String sId = request.getParameter("id");
		this.boardId = tonum(sId);
	}

	protected BoardUrl(int loginMode, int start, int end, int boardId, int itemNum) {
		super("board", loginMode, start, end, itemNum);

		this.boardId = boardId;
	}

	protected void addParamStrings(Vector<String> params) {
		if(boardId > 0) params.addElement("id=" + boardId);

		super.addParamStrings(params);
	}

	public ThreadUrl getThreadTopUrl(UserConfig user, int boardId, int nid) {
		return new ThreadUrl(loginMode, 0, user.pageArticleNum-1, boardId, nid, user.pageThreadNum, 0, ContentsConverter.CONVERTER_TYPE_DEFAULT);
	}
}
