/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.aibonware.inaver.task.stat;

import java.io.*;
import java.text.*;
import java.util.*;
import com.aibonware.inaver.store.*;
import com.aibonware.inaver.task.RoutineWorkException;

/**
 * ̐ꂽRg̑}ev[gύX邽
 * EBhE > ݒ > Java > R[h > R[hƃRg
 */
public abstract class StatWork {
	public static final int PERIOD_DAY = 0;
	public static final int PERIOD_WEEK = 1;
	public static final int PERIOD_MONTH = 2;

	private static final SimpleDateFormat df = new SimpleDateFormat("yyyy.MM.dd");
	private final int period;
	private final int limitNum;
//	private final String statName;
	private final String statDispName;
	
	public StatWork(String statName, String statDispName, int period, int limitNum) {
		this.period = period;
		this.limitNum = limitNum;
//		this.statName = statName;
		this.statDispName = statDispName;
	}
		
	public void execute(BackupStore store, Date firstDate, Date lastDate, PrintWriter writer) throws RoutineWorkException {
		try {
//			GregorianCalendar calendar = new GregorianCalendar();
			
			String title = "";

			if(period == PERIOD_DAY) {
				title = df.format(firstDate) + " " + statDispName;
			} else {
				GregorianCalendar lastDispCalendar = new GregorianCalendar();
				lastDispCalendar.setTime(lastDate);
				lastDispCalendar.add(Calendar.DATE, -1);
				Date lastDispDate = lastDispCalendar.getTime();
			
				title = df.format(firstDate) + "-" + df.format(lastDispDate)  + " " + statDispName;
			}

			if(limitNum>0) title = title + " Top" + limitNum;

			doStat(store, title, firstDate, lastDate, limitNum, writer);

		} catch(StoreException e) {
			throw new RoutineWorkException(e);
		}
	}
	
	public abstract void doStat(
		BackupStore store,
		String title, 
		Date firstDate,
		Date lastDate,
		int limitNum,
		PrintWriter writer) throws StoreException;
}
