/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.inaver.task;

import com.aibonware.inaver.*;
import com.aibonware.inaver.store.*;
import com.aibonware.nvrlib.model.*;

/**
 * 
 */
public class CrawlerStage extends TaskStage {
	public MasterStore store = null;
	public Board board = null;
	public final int count;
	public volatile int succeededCount = 0;
    public int maxArticleId = 0;
 	
	public CrawlerStage(int count) {
		this.count = count;
	}
	
	public void afterStage() {
		try {
			if(store != null) {
				if(available && board != null && succeededCount>0) store.updateBoardCrawlTime(board);

               store.close();
               BackupStore backup = INaver.getInstance().getStoreProvider().openBackupStore();
               
               // ̔̍ő僌XIDf[^x[XɊi[
               backup.updateMaxArticleId(board.boardId, maxArticleId);

               backup.close();
			} 

		} catch(StoreException e) {
			Log.err(e);
		}

		Scheduler masterScheduler = INaver.getInstance().getMasterScheduler();
		Scheduler backupScheduler = INaver.getInstance().getBackupScheduler();
		BoardCrawler boardCrawler = new BoardCrawler(count+1);

        int interval;

        if(board == null) {
            Log.info("warning: CrawlerStage.board is null");
            interval = 180;
        } else {
            interval = board.interval;
        }
        
        // 5ƂɃobNAbvXgA𓯊
//        if((count % 5) == 0) {
        	if(backupScheduler.nowStarted) {
        		backupScheduler.addTask(new SyncStoreTask());
        	}
//        }

        // ŐVXXgXV
    	if(backupScheduler.nowStarted && board != null) {
    		backupScheduler.addTask(new UpdateArticleListTask(board));
    	}
     
        masterScheduler.addTask(new WaitTask(interval *1000 , boardCrawler.stage));
        masterScheduler.addTask(boardCrawler);
		Log.info("end crawling");
	}
}
