/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.inaver.store;

import java.util.*;

import com.aibonware.nvrlib.model.*;
import com.aibonware.inaver.model.*;

//}X^ł̂ݗp\ȃT[rX
public interface MasterStore {
	public static final String REGISTER_OK = "OK";
	
	public String getDBName();
	
	public void close() throws StoreException;
	public BoardList queryBoardList(boolean mustVisible, boolean mustCrawlable) throws StoreException;
	public Board queryBoard(int srcBoardId) throws StoreException;

	public ThreadList queryThreadList(
			int boardId, 
			int start, 
			int num, 
			String[] topPosters,
			boolean newThreadToTop,
			int minArticleNum,
			Vector<String> delPosters) throws StoreException;

	public int queryThreadListOnLogMode(
			int boardId, 
			int start, 
			int num,
			ThreadList threadList) throws StoreException;
	
	
	public ArticleList queryArticleList(int boardId, int nid, int start, int num, Vector<String> delPosters) throws StoreException;
	public ThreadDiff getThreadDiff(int boardId, ThreadTitle threadSummary) throws StoreException;
	public int getLastArticleId(int boardId, int nid) throws StoreException;
	public String queryThreadContents(int boardId, int nid) throws StoreException;
	public String queryRawThreadContents(int boardId, int nid) throws StoreException;
 	public NThread queryThread(int boardId, int nid) throws StoreException;
	public ThreadTitle queryThreadTitle(int boardId, int nid) throws StoreException;
	public boolean existsThread(int boardId, int threadId) throws StoreException;
	public int queryThreadTraffic(int boardId, int nid) throws StoreException;
	public UserConfig getUser(int userId) throws StoreException;
	public void deleteUser(int userId) throws StoreException;
	public Vector<UserConfig> getUserList() throws StoreException;
	public UserConfig loginUser(String userName, String password) throws StoreException;
	public UserConfig fastLoginUser(String auth) throws StoreException;
	public String registerUser(String userName, String password, int rand) throws StoreException;
	public void updateUser(UserConfig user) throws StoreException;
	public void updateUserPassword(UserConfig user, String newPassword) throws StoreException;
	public int addDeleteRequest(int boardId, int threadId, String sReason) throws StoreException;
	public Vector<DelRequest> queryDelRequestList() throws StoreException;
	public int getActiveDelRequestCount() throws StoreException;
	public DelRequest queryDelRequest(int requestId) throws StoreException;
	public void updateDelStatus(int requestId, int newStatus) throws StoreException;
	public void updateNaverAccount(int userId, boolean doEncrypt, String nvrPassword, String naverId, String password, String articlePassword) throws StoreException;
	public NaverAccount queryNaverAccount(int userId, String nvrPassword) throws StoreException;
	public void updateThread(int boardId, String contents, String rawContents, NThread thread, ArticleList articleList, int lastArticleId) throws StoreException;
	public void updateBoardCrawlTime(Board board) throws StoreException;
	public void updateThreadCrawlTime(int boardId, NThread thread) throws StoreException;
	public void insertThread(int boardId, String contents, String rawContents, NThread thread, ArticleList articleList) throws StoreException;
	public void deleteThread(int boardId, int nid) throws StoreException;
	public void updateThreadTraffic(int boardId, int nid, int trafficToAdd) throws StoreException;
	public HashSet<Poster> queryDenyList() throws StoreException;
	public void updateArticles(int boardId, int nid, ArticleList articleList, int lastArticleId) throws StoreException;
	public ArticleFullPathList queryNewArticles(int boardId, int num) throws StoreException;
}
