/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.inaver.servlet;

import java.util.*;
import com.aibonware.inaver.conv.*;
import java.io.*;
import javax.servlet.http.*;
import com.aibonware.inaver.*;
import com.aibonware.inaver.model.*;
import com.aibonware.inaver.store.*;
import com.aibonware.inaver.task.*;
import com.aibonware.inaver.url.*;
import com.aibonware.nvrlib.model.*;

@SuppressWarnings("serial")
public class UpdateServlet extends AuthServlet {
	public UpdateServlet() {
		super(AUTO_OPEN_MASTER_STORE);
	}

	protected void dispContents(AuthServletContext ct) throws StoreException {
		PrintWriter out = ct.out;
		UpdateUrl updateUrl = (UpdateUrl)ct.authUrl;
		INaver inaver = ct.inaver;
		MasterStore store = ct.store;
//		HttpSession session = ct.request.getSession(false);

		UserConfig user = ct.user;

		if(updateUrl.loginMode != 1) {
			out.println("OCĂ܂");
			return;
		}

		// wb_
		out.println(
			"<html><head><meta http-equiv='Content-type' content='text/html; "
			+ "charset=Shift_JIS'><title>XV</title>");

		int boardId = updateUrl.boardId;
		int nid = updateUrl.nid;

        Log.info(user.userName + " update bid=" + boardId + " nid=" + nid);
        
        Board board = store.queryBoard(boardId);
        
        if(board.lockNid >= nid) {
        	out.println("̽گނ̍XVۯĂ܂.");
        	return;
        }

        HashSet<Poster> denyList = store.queryDenyList();
        ThreadTitle threadSummary = store.queryThreadTitle(boardId, nid);
		ThreadCrawler crawler = new ThreadCrawler(store, board, threadSummary, new TaskStage(), true, denyList);
		inaver.getMasterScheduler().addUrgentTask(crawler);
		crawler.waitDone();

		if(crawler.exception != null) {
			out.println("</head><body>");
			out.println("XVsF " + crawler.exception.getMessage());		
			out.println("</body></html>");
		} else {
			ThreadUrl threadUrl = updateUrl.getThreadUrl(user);

			String newUrl;

			if(true) {
				newUrl = threadUrl.toString(ct.response) + "#" + updateUrl.artNo;
			} else {
				// XVȂ̏ꍇ͍Ōɍs...
				newUrl = threadUrl.toString(ct.response) + "#bottom";
			}

			out.println("<meta http-equiv=\"Refresh\" content=\"0; URL=" + newUrl + "\">");
			out.println("</head><body>");
			out.println("<a href=\"" + newUrl + " \">XVʂ{</a>");
			out.println("</body></html>");
		}
	}

	protected AuthServletContext createContext(HttpServletRequest request, HttpServletResponse response, MasterStore store, INaver inaver, PrintWriter out, UserConfig user) throws IOException, StoreException {
		int itemNum = 10;

		if(user != null) itemNum = user.pageArticleNum;
		ContentsConverter converter = inaver.getContentsConverter(ContentsConverter.CONVERTER_TYPE_DEFAULT);

		return new UpdateContext(user, request, response, store, inaver, out, converter, new UpdateUrl(request, itemNum));
	}
}
