/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.inaver.servlet;

import java.io.*;

import javax.servlet.*;
import javax.servlet.http.*;

import com.aibonware.inaver.*;
import com.aibonware.inaver.model.*;
import com.aibonware.inaver.store.*;
import java.util.regex.*;

@SuppressWarnings("serial")
public class NaverAccountServlet extends HttpServlet {
	private static Pattern pat = Pattern.compile("\\w+");

	public NaverAccountServlet() {}
	
	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
		doGetOrPost(request, response, true);
	}

	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
		doGetOrPost(request, response, false);
	}

	private void doGetOrPost(HttpServletRequest request, HttpServletResponse response, boolean isFirst) {
		try {
			response.setContentType("text/html; charset=MS932");
			PrintWriter out = response.getWriter();

			INaver inaver = INaver.getInstance();
		
			if(inaver == null) {
				Log.err("service not running");
				out.println("service not running");
				out.close();
				return;
			}

			UserConfig user = null;
			HttpSession session = request.getSession(false);

			if(session != null) user = (UserConfig)session.getAttribute("userconfig");

			if(user == null) {
				out.println("<html><head><meta http-equiv='Content-type' content='text/html; charset=Shift_JIS'>");
				out.println("<title>NAVERď</title></head><body>");

				out.println("OCĂ܂B");
				out.println("</body></html>");
			} else {
				SQLStoreProvider storeProvider = inaver.getStoreProvider();
				MasterStore store = storeProvider.openMasterStore();

				NaverAccountContext ct = new NaverAccountContext(
					request, 
					response,
					store,
					inaver,
					out,
					user);

				dispContents(ct, user, isFirst);

				store.close();
			}

		} catch(Exception e) {
			Log.err(e);

			try {
				PrintWriter out = response.getWriter();
				out.println(e.getMessage());
				
				out.close();
			} catch(Exception e2) {
			}
		}
	}

	protected int tonum(String s) {
		try {
			return Integer.parseInt(s);
		} catch(Exception e) {
			return -1;
		}
	}

	protected boolean checkToBool(String s) {
		if(s == null) return false;
		return s.equals("on");
	}

	private void dispContents(NaverAccountContext ct, UserConfig user, boolean isFirst) throws StoreException {
		PrintWriter out = ct.out;
		HttpServletRequest request = ct.request;
		MasterStore store = ct.store;

		out.println("<html><head><meta http-equiv='Content-type' content='text/html; charset=Shift_JIS'>");
		out.println("<title>NAVERAJEg</title></head><body>");

		String announcement = Env.getEnv().announcement;
		if(!announcement.equals("")) out.println("<font color=\"red\">" + announcement + "</font><br>");

        Log.info(user.userName + " naver account");
        
		if(isFirst) {
			out.println("KJX<a href=\"http://yy14.kakiko.com/test/r.i/naver/1112639710/20-21\">gp@̐</a>ǂł炲pB<br>");
			out.println("<form method=post action=\"" + ct.createCurrentUrl() + "\">");

			out.print("<input type=checkbox name=\"DoEncrypt\" value=\"on\" checked>");
			out.println("NAVERAJEggуTCgppX[hňÍ<br>");
			out.println("@gуTCgppX[hē: <input type=text name=INVRPassword value=\"\"><br>");
			out.println("NAVEROCID: <input type=text name=NaverID value=\"\"><br>");
			out.println("NAVEROCpX[h: <input type=text name=Password value=\"\"><br>");
			out.println("X폜ppX[h: <input type=text name=ArticlePassword value=\"\"><br>");
	
			out.println("<input type=submit value=\"ݒ\">");
			out.println("</form>");
		} else {
			boolean doEncrypt = checkToBool(request.getParameter("DoEncrypt"));
			String invrPassword = request.getParameter("INVRPassword");
			String naverId = request.getParameter("NaverID");
			String password = request.getParameter("Password");
			String articlePassword = request.getParameter("ArticlePassword");

			String err = "";
			
			if(!pat.matcher(naverId).matches()) {
				err = err + "NAVEROCIDsł<br>";
			}			
			
			if(!pat.matcher(password).matches()) {
				err = err + "NAVEROCpX[hsł<br>";
			}			

			if(!pat.matcher(articlePassword).matches()) {
				err = err + "X폜ppX[hsł<br>";
			}			

			if(doEncrypt && store.loginUser(user.userName, invrPassword) == null) {
				err = err + "gуTCgppX[hĂ܂<br>";
			}
			
			if(!err.equals("")) {
				out.println(err);
			} else {
				store.updateNaverAccount(user.userId, doEncrypt, invrPassword, naverId, password, articlePassword);
	
				HttpSession session = request.getSession(false);
				session.setAttribute("naveraccount", store.queryNaverAccount(user.userId, invrPassword));
	
				out.println("ݒ芮B<br>");
			}
		}

		out.println("</body></html>");
	}
}
