/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.inaver.servlet;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import com.aibonware.inaver.*;
import com.aibonware.inaver.model.*;
import com.aibonware.inaver.store.*;
import com.aibonware.inaver.url.*;

/**
 * 
 */
@SuppressWarnings("serial")
public class DeleteResultServlet extends HttpServlet {
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
		try {
			request.setCharacterEncoding("Shift_JIS");
			response.setContentType("text/html; charset=Shift_JIS");
			PrintWriter out = response.getWriter();
			out.println("<html><head><meta http-equiv='Content-type' content='text/html; charset=Shift_JIS'>");

			INaver inaver = INaver.getInstance();
		
			if(inaver == null) {
				dispServiceError(out);
			} else {
				SQLStoreProvider storeProvider = inaver.getStoreProvider();
				MasterStore store = storeProvider.openMasterStore();

				String sCommand = request.getParameter("command");

				if("request_delete".equals(sCommand)) {
					out.println("<title>\</title></head><body>");

					String sBoardID = request.getParameter("BoardID");
					String sNID = request.getParameter("NID");
					String sReason = request.getParameter("Reason");

					requestDelete(out, store, sBoardID, sNID, sReason);

				} else if("query_delete".equals(sCommand)) {
					out.println("<title>\mF</title></head><body>");

					String sRequestID = request.getParameter("RequestID");

					queryDelete(out, store, sRequestID);
				}

				store.close();
			}

			out.println("</body></html>");
			out.close();

		} catch(Exception e) {
			Log.err(e);

			try {
				PrintWriter out = response.getWriter();
				out.println(e.getMessage());
				
				out.close();
			} catch(Exception e2) {
			}
		}
	}

	private void dispServiceError(PrintWriter out) {
		out.println("G[F݃VXeɋNĂ܂BԂuāAēx\肢܂B");
	}
	
	private void requestDelete(PrintWriter out, MasterStore store, String sBoardID, String sNID, String sReason) throws StoreException {
		if(sReason == null || sReason.trim().equals("")) {
			out.println("G[FRłB");
			return;
		}

		sReason = sReason.trim();
		
		if(sReason.length() > 300) {
			out.println("G[FR300𒴂Ă܂B");
			return;
		}

		int boardID = AuthUrl.tonum(sBoardID);
		int nid = AuthUrl.tonum(sNID);
		
		if(!store.existsThread(boardID, nid)) {
			out.println("G[Fw肳ꂽXbh݂͑܂B");
			return;
		}
		
		int requestID = store.addDeleteRequest(boardID, nid, sReason);
		
		out.println("\e͐ɓo^܂B<br>");
		out.println("tԍ: " + requestID);
	}
	
	private void queryDelete(PrintWriter out, MasterStore store, String sRequestID) throws StoreException {
		int requestID = AuthUrl.tonum(sRequestID);

		if(requestID <= 0) {
			out.println("G[FsȎtԍłB");
			return;
		}
		
		DelRequest req = store.queryDelRequest(requestID);
		int status;

		if(req == null) status = DelRequest.DELSTAT_ERROR;
		else status = req.status;
		
		out.print("݂̏ԁF");

		switch(status) {
			case DelRequest.DELSTAT_OPEN:
				out.println("OPEN");
				break;
			case DelRequest.DELSTAT_ACCEPTED:
				out.println("ACCEPTED");
				break;
			case DelRequest.DELSTAT_REJECTED:
				out.println("REJECTED");
				break;
			case DelRequest.DELSTAT_ERROR:
				out.println("ERROR");
				break;
		}
	}
}
