/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.inaver.servlet;

import java.util.*;
import java.io.*;
import java.text.*;
import javax.servlet.http.*;
import com.aibonware.inaver.*;
import com.aibonware.nvrlib.model.*;
import com.aibonware.inaver.model.*;
import com.aibonware.inaver.store.*;
import com.aibonware.inaver.url.*;

@SuppressWarnings("serial")
public class BoardServlet extends AuthServlet {
	public BoardServlet() {
		super(AUTO_OPEN_MASTER_STORE);
	}

	private static SimpleDateFormat tf = new SimpleDateFormat("MM/dd HH:mm");

	protected AuthServletContext createContext(HttpServletRequest request, HttpServletResponse response, MasterStore store, INaver inaver, PrintWriter out, UserConfig user) throws IOException, StoreException {
		return new BoardContext(user, request, response, store, inaver, out, new BoardUrl(request, user.pageThreadNum));
	}

	protected void dispContents(AuthServletContext queryContext) throws StoreException {
		BoardContext ct = (BoardContext)queryContext;
		
		MasterStore store = ct.store;
		PrintWriter out = ct.out;
		INaver inaver = ct.inaver;
		HttpServletRequest request = ct.request;
		HttpServletResponse response = ct.response;
		UserConfig user = null;
		HttpSession session = request.getSession(false);
		if(session != null) user = (UserConfig)session.getAttribute("userconfig");
		BoardUrl boardUrl = (BoardUrl)ct.authUrl;

		Vector<String> delPosters = null;
		if(user != null) delPosters = user.filterThreadPosters;

		if(user == null) user = new UserConfig();

		int nStart = boardUrl.start;
		int nEnd = boardUrl.end;
		int nNum = nEnd - nStart + 1;
		int nLoginMode = boardUrl.loginMode;
		int nBoardId = boardUrl.boardId;
        
        Log.info(user.userName + " query board " + nBoardId + " s=" + nStart + " n=" + nNum);

		Board board = store.queryBoard(nBoardId);
		
		// wb_
		out.println("<html><head><meta http-equiv='Content-type' content='text/html; charset=Shift_JIS'>");
		out.println("<title>" + board.dispName + "</title></head><body>"); 

		String announcement = Env.getEnv().announcement;
		if(!announcement.equals("")) out.println("<font color=\"red\">" + announcement + "</font><br>");

		if(nLoginMode == 0) {
			out.print("<a href=\""+ boardUrl.toLogin(response) + "\">۸޲</a>");
		} else {
			if((user.flags & UserConfig.BOARD_HEADER_SHOW_INDEX) != 0) {
				out.print("<a href=\""+ boardUrl.getIndexUrl(user).toString(response) + "\"></a>");
			}

			if((user.flags & UserConfig.BOARD_HEADER_SHOW_PREV) != 0) { 
				out.print("<a href=\"" + boardUrl.prev(response) + "\">O</a>");
			}

			if((user.flags & UserConfig.BOARD_HEADER_SHOW_NEXT) != 0) {
				out.print("<a href=\"" + boardUrl.next(response) + "\"></a>");
			}

			if((user.flags & UserConfig.BOARD_HEADER_SHOW_LOGIO) != 0) {
				out.print("<a href=\""+ boardUrl.toLogout(response) + "\">۸ޱ</a>");
			}

			if((user.flags & UserConfig.BOARD_HEADER_SHOW_CONFIG) != 0) {
				out.print("<a href=\"" + boardUrl.getConfigTopUrl(user).toString(response) + "\">ݒ</a>");
			}
			
			if((user.flags & UserConfig.BOARD_HEADER_SHOW_SEARCH) != 0) {
				out.print("<a href=\"" + boardUrl.getSearchTopUrl(user).toString(response) + "\"></a>");
			}
		}

		out.println("<hr>");
		
		ThreadList threadList;
		
		if(nStart > 3000) {
			threadList = new ThreadList();
			int startnid = store.queryThreadListOnLogMode(nBoardId, nStart, nNum, threadList);
			out.println("<b>ߋO{[hF</b> NID=" + startnid + "~<br>");
			out.println("<hr>");
		} else {
			threadList = store.queryThreadList(nBoardId, nStart, nNum, null, user.threadFlowEnabled(), user.minThreadNum, delPosters);
		}

		// eXbh̃T}
		for(int i=0; i<threadList.getThreadCount(); i++) {
			NThread thread = threadList.getThread(i);

			// XbhԍƃN
			ThreadUrl threadUrl = boardUrl.getThreadTopUrl(user, nBoardId, thread.nid);
			out.print("<a href=\"" + threadUrl.toString(response)+ "\">" + (nStart+i+1) + "</a>");

			if(thread.depth > 0) out.print("(r)");
			out.print(".");

			// ʁEeҁEXbh^CgE쐬
			out.print(thread.title + " ");
			out.print(INaver.getCountryHtml(thread.country) + " ");			
			out.print("<b>" + thread.poster + "</b> ");
			
			if((user.flags & UserConfig.BOARD_THREAD_SHOW_MAIL) != 0) {
				if(thread.mail != null && !thread.mail.equals("") && !thread.mail.equals("null")) {
					out.print(thread.mail + " ");
				}
			}

			out.print(tf.format(thread.createDate)  + " ");

			// Xbh
			out.print("[" + thread.articleNum + "]<hr>");

			out.println();
		}

		if((user.flags & UserConfig.BOARD_FOOTER_SHOW_INDEX) != 0) {
			out.print("<a href=\""+ boardUrl.getIndexUrl(user).toString(response) + "\"></a>");
		}

		if((user.flags & UserConfig.BOARD_FOOTER_SHOW_PREV) != 0) { 
			out.print("<a href=\"" + boardUrl.prev(response) + "\">O</a>");
		}

		if((user.flags & UserConfig.BOARD_FOOTER_SHOW_NEXT) != 0) {
			out.print("<a href=\"" + boardUrl.next(response) + "\"></a>");
		}
		
		if((user.flags & UserConfig.BOARD_FOOTER_SHOW_LOGIO) != 0) {
			out.print("<a href=\""+ boardUrl.toLogout(response) + "\">۸ޱ</a>");
		}

		if((user.flags & UserConfig.BOARD_FOOTER_SHOW_CONFIG) != 0) {
			out.print("<a href=\"" + boardUrl.getConfigTopUrl(user).toString(response) + "\">ݒ</a>");
		}
			
		if((user.flags & UserConfig.BOARD_FOOTER_SHOW_SEARCH) != 0) {
			out.print("<a href=\"" + boardUrl.getSearchTopUrl(user).toString(response) + "\"></a>");
		}

		if(!user.isGuest) {
			long busyTime = inaver.getBackupScheduler().getBusyTime();
			if(busyTime > 10000) out.println(" <font color=\"gray\">(" + (busyTime/1000) + ")</font>");
		}

		if(board.lastCrawlTime != null) out.println("<hr>XV: " + tf.format(board.lastCrawlTime));

		out.println("</body></html>");
	}
}
