/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.inaver.servlet;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import com.aibonware.inaver.*;
import com.aibonware.inaver.model.*;
import com.aibonware.inaver.store.*;
import com.aibonware.inaver.url.*;
import com.aibonware.nvrlib.*;

public abstract class AuthServlet extends HttpServlet {
	public static final int AUTO_OPEN_NONE = 0;
	public static final int AUTO_OPEN_MASTER_STORE = 1;

	private int storeType;
	
	public AuthServlet(int storeType) {
		this.storeType = storeType;
	}

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
		callGetOrPost(request, response);
	}

	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
		callGetOrPost(request, response);
	}

	private void callGetOrPost(HttpServletRequest request, HttpServletResponse response) {
		try {
			request.setCharacterEncoding("Shift_JIS");
			response.setContentType("text/html; charset=Shift_JIS");
			PrintWriter out = response.getWriter();

			INaver inaver = INaver.getInstance();
		
			if(inaver == null) {
				Log.err("service not running");
				out.println("service not running");
				out.close();
				return;
			}

			MasterStore store = null;
	
			if(storeType == AUTO_OPEN_MASTER_STORE) {
				SQLStoreProvider storeProvider = inaver.getStoreProvider();
				store = storeProvider.openMasterStore();
			}

			doGetOrPost(request, response, store, inaver, out);

			if(store != null) store.close();
			out.close();

		} catch(Exception e) {
			Log.err(e);

			try {
				PrintWriter out = response.getWriter();
				out.println(e.getMessage());
				
				out.close();
			} catch(Exception e2) {
			}
		}
	}

	private boolean isMobileAgent(AuthServletContext ct) {
		String userAgent = ct.request.getHeader("User-Agent");

		if(userAgent == null) return false;

		userAgent = userAgent.toLowerCase();

		for(String validAgent: Env.getEnv().getMobileUserAgentsArray()) {
			if(userAgent.contains(validAgent)) return true;
		}

		return false;
	}

	private void dispMobileLogin(AuthServletContext ct) {
		ct.out.println("gђ[ȊO̱aibonware̓o^ςհނ̂݉\ł.<br>"
			+ "o^հނ<a href=\"" + ct.authUrl.toLogin(ct.response) + "\"></a>۸޲݂Ă.");
	}

	protected void doGetOrPost(
	  HttpServletRequest request,
	  HttpServletResponse response,
	MasterStore store,
	  INaver inaver,
	  PrintWriter out) throws IOException, ServletException {
		try {
			int nLoginMode = AuthUrl.getLoginMode(request);

			if(nLoginMode <= 0) { //OC
				// OCZbV݂ĂA폜
				HttpSession session = request.getSession(false);
				if(session != null) {
                    UserConfig user = (UserConfig)session.getAttribute("userconfig");

                    if(user != null) Log.info("logout " + user.userName);
					
					NaverSession naverSession = (NaverSession)session.getAttribute("naversession");
					if(naverSession != null && naverSession.nowLogin()) {
						try {
							naverSession.logout();
							Log.info("logout naver");
						} catch(NetException e) {
							Log.err(e);
						}
					}
					
					session.invalidate();
				}

				AuthServletContext ct = createContext(request, response, store, inaver, out, UserConfig.getGuest());

				if(!isMobileAgent(ct)) {
					// gъÕANZX̏ꍇAOCv
					dispMobileLogin(ct);
				} else {
					// e\
					dispContents(ct);
				}

			} else if(nLoginMode == 1) { // OC
				// OCZbV쐬/擾
				HttpSession session = request.getSession(true);
				UserConfig user = (UserConfig)session.getAttribute("userconfig");

				boolean isFirstLogon = session.isNew();
				boolean authenticated = (user != null);

				if(isFirstLogon) {
					// VKɍ쐬ꂽꍇA܂OCĂȂ̂ŁAOCʕ\
					AuthServletContext ct = createContext(request, response, store, inaver, out, UserConfig.getGuest());
					dispLoginForm(ct, false);
				} else if(authenticated) {
					// [UIDo^ς݂̏ꍇARec\
					AuthServletContext ct = createContext(request, response, store, inaver, out, user);
					dispContents(ct);
				} else {
					// [UIDo^̏ꍇA񃍃OIȂ̂ŁAF؂s
					String userName = request.getParameter("name");
					String password = request.getParameter("password");
					
                    Log.info("login " + userName);

					user = store.loginUser(userName, password);

					if(user != null) {
						// F؂ɐA[UIDo^ARec\
						AuthServletContext ct = createContext(request, response, store, inaver, out, user);
                        
						session.setAttribute("userconfig", user);
						session.setAttribute("naveraccount", store.queryNaverAccount(user.userId, password));
						
						dispContents(ct);
					} else {
                        Log.info("login failed");
                        
						// F؂ɎsAăOCʕ\
						AuthServletContext ct = createContext(request, response, store, inaver, out, new UserConfig());

						dispLoginForm(ct, true);
					}
				}
			}
		} catch(Exception e) {
			Log.err(e);

			try {
				out.println(e.getMessage());
				out.close();
			} catch(Exception e2) {
			}
		}
	}

	private void dispLoginForm(AuthServletContext ct, boolean relogin) throws StoreException {
		PrintWriter out = ct.out;

		// wb_
		out.println("<html><head><meta http-equiv='Content-type' content='text/html; charset=Shift_JIS'>");
		out.println("<title>۸޲</title></head><body>");

		if(relogin) {
			out.println("<font color=\"red\">[U܂̓pX[hĂ܂B</font>");
		} else {
			out.println("<font color=\"red\">Enjoy Korea۸޲ݏ͓͂ȂłI</font>aibonwareo^հޗp۸޲݉ʂł.");
		}

		out.println("<form method=post action=\"" + ct.authUrl.toLogin(ct.response) + "\">");
		out.println("O: <input type=text name=name><br>");
		out.println("߽ܰ: <input type=password name=password><br>");
		out.println("<input type=submit value=\"۸޲\">");
		out.println("</form>");

		out.println("</body></html>");
	}

	protected abstract void dispContents(AuthServletContext queryContext) throws Exception;
	protected abstract AuthServletContext createContext(HttpServletRequest request, HttpServletResponse response, MasterStore store, INaver inaver, PrintWriter out, UserConfig user) throws IOException, StoreException;
}
