/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.inaver.conv;

/**
 * HTML̓eei-modepHTMLɕϊA܂Aϊʂ̃Rec̐擪؂B
 * <p>ContentsConverter̃CX^X͍ėp邽߁Aconvert\bhytoShort\bh
 * 킸Ăяo\łȂ΂Ȃ炸A܂Äɂē̌ʂԋpȂ΂ȂȂB
 */
public interface ContentsConverter {
    public static final int CONVERTER_TYPE_DEFAULT = 0;
    public static final int CONVERTER_TYPE_NULL = 1;
    public static final int CONVERTER_TYPE_NEKO = 2;

    /**
	 * CX^X̏sB
	 * <p>{\bh́AContentsConverterCX^Xɑ΂1xĂяoB
	 */
	public void init();

	/**
	 * htmlContentsŎw肳ꂽHTMLRec̓eAi-modepHTMLRecɕϊB
	 * <p>ԋpʂ̓ubNvf܂̓CCvfłȂ΂ȂȂB
	 * <p>htmlContents̓e͒ʏubNvf܂̓CCvfłBAXbh쐬҂
	 * ɐHTML̒mč쐬ĂƂ͌Ȃ߁AI^Ǒ@ȂǕsHTML
	 * ^Ăł邾I邱ƁB
	 * 
	 * @throws ConverterException ϊɎsB
	 * @return ϊʂi-modepHTMLRecB
	 */
	public String convert(String imagegUrl, String htmlContents) throws ConverterException;

	/**
	 * convert\bhœꂽi-modepRec̐擪؂oAԋpB
	 * <p>{\bh́A̓eeɑ΂āA͂߂ɓe̐擪݂̂𗘗p҂ɒ񎦂A
	 * p҂̃ANVɂǍconvert\bhɂS̓e񎦂ƂViI
	 * 邽߂̃\bhłB
	 * <p>desiredLineNumdesiredCharNumɂ́Aꂼ؂oꂽRec
	 * ]܂ősAyі]܂ő啶i[B̏ɖ邱Ƃ
	 * ]܂A̒l͐lłA{\bh͂̒l𖳎ĂǂB
	 * <p>contentsŎw肳ꂽRecZłꍇ́A؂os킸A
	 * Pcontentsԋp邱ƁB
	 * <p>linkɂ́ASẴRec\邽߂̃N\a^ŐLqi[B
	 * {\bh̏ʂɁA̕܂߂邱ƁB
	 * 
	 * @param desiredLineNum ؂oʂƂĖ]܂sB
	 * @param desiredCharNum ؂oʂƂĖ]܂B
	 * @param contents convert\bhɂϊꂽi-modepRecSB
	 * @return ؂oʂ̃RecB
	 */
	public String getShortContents(
			int desiredLineNum,
			int desiredCharNum,
 			String contents,
			String link);
}
