/*
 * complex operation program copyright (C) 2009 - 2011 H.Niwa
 */

/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#ifndef __COMPLX_H__
#define __COMPLX_H__

extern int CReal(Context* cx, Node* goalscar, List* module);
extern int CImage(Context* cx, Node* goalscar, List* module);

extern int CAbs(Context* cx, Node* goalscar, List* module);
extern int CArg(Context* cx, Node* goalscar, List* module);
extern int CNorm(Context* cx, Node* goalscar, List* module);
extern int CConj(Context* cx, Node* goalscar, List* module);
extern int CPolar(Context* cx, Node* goalscar, List* module);

extern int CSin(Context* cx, Node* goalscar, List* module);
extern int CCos(Context* cx, Node* goalscar, List* module);
extern int CTan(Context* cx, Node* goalscar, List* module);

extern int CASin(Context* cx, Node* goalscar, List* module);
extern int CACos(Context* cx, Node* goalscar, List* module);
extern int CATan(Context* cx, Node* goalscar, List* module);

extern int CSinh(Context* cx, Node* goalscar, List* module);
extern int CCosh(Context* cx, Node* goalscar, List* module);
extern int CTanh(Context* cx, Node* goalscar, List* module);

extern int CASinh(Context* cx, Node* goalscar, List* module);
extern int CACosh(Context* cx, Node* goalscar, List* module);
extern int CATanh(Context* cx, Node* goalscar, List* module);

extern int CLog(Context* cx, Node* goalscar, List* module);
extern int CLog10(Context* cx, Node* goalscar, List* module);

extern int CPow(Context* cx, Node* goalscar, List* module);
extern int CSqrt(Context* cx, Node* goalscar, List* module);
extern int CBrt(Context* cx, Node* goalscar, List* module);

extern int CExp(Context* cx, Node* goalscar, List* module);
extern int CExp2(Context* cx, Node* goalscar, List* module);
extern int CExp10(Context* cx, Node* goalscar, List* module);

extern int ATan2(Context* cx, Node* goalscar, List* module);

extern int PI(Context* cx, Node* goalscar, List* module);
extern int E(Context* cx, Node* goalscar, List* module);

#ifndef __MINGW32__
extern int isInf(Context* cx, Node* n, List* module);
extern int isNan(Context* cx, Node* n, List* module);
extern int Finite(Context* cx, Node* n, List* module);
#endif

extern int Int(Context* cx, Node* goalscar, List* module);
extern int Floor(Context* cx, Node* goalscar, List* module);
extern int Ceil(Context* cx, Node* goalscar, List* module);
extern int Trunc(Context* cx, Node* goalscar, List* module);

#endif

