/*
 * Copyright 2009-2015 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * morilib Nina Version: 0.4.13.498
 *
 * Nina homepage:      http://nina.morilib.net/
 * Plugin update site: http://nina.morilib.net/update-site/
 */
package net.morilib.deculture.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import net.morilib.automata.lr.ContextFreeRule;
import net.morilib.automata.lr.GrammarSymbol;
import net.morilib.automata.lr.Nonterminal;
import net.morilib.automata.lr.Terminal;
import net.morilib.deculture.misc.CharacterTerminal;
import net.morilib.deculture.misc.ConstantNonterminal;
import net.morilib.deculture.misc.ConstantTerminal;
import net.morilib.deculture.misc.DecultureException;

/**
 *  
 */
public  class DecultureAction   {

	/* @@@-PARSER-CODE-START-@@@ */
	public static class TokenException extends RuntimeException {
	}

	static abstract class Engine {
		abstract int step(int c) throws java.io.IOException;
		abstract boolean accepted();
		abstract boolean isDead();
		abstract boolean isEmptyTransition();
		abstract int execaction(int c);
		abstract boolean isend();
		abstract int recover(Exception e);
		abstract int deadState();
		abstract int stateSize();
		abstract int finallyState();
	}
	static final int INVALIDTOKEN = 0x7fff7fff;
	private static final int NINA_BEGIN = -2;
	private static final int NINA_EOF = -1;
	private static final int NINA_ACCEPT = -8;
	private static final int NINA_FAIL = -9;
	private static final int NINA_HALT_ACCEPT = -91;
	private static final int NINA_HALT_REJECT = -72;
	private static final int NINA_YIELD = -85;
	private static final int NINA_STACKLEN = 72;
	static final int NINA_DISCARDSTATE = 0x40000000;
	static final int INITIAL = 0;
	static final int INDENT = 1;

	private int STATE;
	private int[] __sts = new int[NINA_STACKLEN];
	private Engine[] __stk = new Engine[NINA_STACKLEN];
	private Object[][] __stv = new Object[NINA_STACKLEN][];
	private int __slen = 0;
	private int unread = -1;

	Object _;
	java.util.List<Object> _l;
	Object yieldObject;
	Throwable exception;

	StringBuffer $buffer;
	int $int;
	java.math.BigInteger $bigint;
	Number $num;

	java.util.Stack<java.io.Reader> streamStack =
			new java.util.Stack<java.io.Reader>();

	void _initlist() {
		_l = new java.util.ArrayList<Object>();
	}

	void _addlist(Object x) {
		_l.add(x);
	}

	private int __lookahead_state;
	private int __lookahead_mark = -1;
	private int[] __lookahead = null;
	private int __lookahead_ptr = -1;
	private int[] __lookaheadw = null;
	private int __lookaheadw_ptr = -1;
	private boolean __lookahead_ok = true;

	private int _unreadl = -1;

	void INCLUDE(java.io.Reader rd) {
		if(__lookahead_ptr >= 0) {
			throw new IllegalStateException();
		}
		streamStack.push(rd);
	}

	void INCLUDE(String name) throws java.io.IOException {
		java.io.InputStream ins;

		ins = new java.io.FileInputStream(name);
		INCLUDE(new java.io.InputStreamReader(ins));
	}

	int _read1l() throws java.io.IOException {
		int c;

		while(streamStack.size() > 0) {
			if((c = streamStack.peek().read()) >= 0) {
				return c;
			} else if(streamStack.size() > 1) {
				streamStack.pop().close();
			} else {
				streamStack.pop();
			}
		}
		return NINA_EOF;
	}

	int _read1() throws java.io.IOException {
		int c;

		if(_unreadl != -1) {
			c = _unreadl;
			_unreadl = -1;
		} else if((c = _read1l()) == '\r' && (c = _read1l()) != '\n') {
			_unreadl = c;
			c = '\r';
		}
		return c;
	}

	private int _read() throws java.io.IOException {
		int c;

		while(true) {
			if(unread != -1) {

				c = unread;
				unread = -1;
				__logprint("Read unread: ", c);
			} else if(__lookahead_ptr >= 0) {
				if(__lookahead_ptr < __lookahead.length) {
					c = __lookahead[__lookahead_ptr++];
				} else {
					__lookahead = null;
					__lookahead_ptr = -1;
					c = _read();
				}
				__logprint("Read Lookahead: ", c);
			} else if((c = _read1()) != -1) {
				__logprint("Read: ", c);
			} else {
				__logprint("Read end-of-file");
			}
			return c;
		}
	}

	void UNGET(int c) {
		unread = c;
		__logprint("Set unread: ", c);
	}

	void __sleep(int m) {
		try {
			Thread.sleep(m);
		} catch(InterruptedException e) {
			throw new RuntimeException(e);
		}
	}

	private void __logprint(String s, int c) {
	}

	private void __logopen() {
	}

	private void __logprint(String s) {
	}

	private void __logclose() {
	}

	private void __puttrace() {
	}

	void LOOKAHEAD(int c) {
		int[] a;

		if(__lookaheadw == null) {
			__lookahead_state = STATE;
			__lookaheadw = new int[72];
			__lookaheadw_ptr = 0;
			__lookaheadw[__lookaheadw_ptr++] = c;
		} else if(__lookaheadw_ptr < __lookaheadw.length) {
			__lookaheadw[__lookaheadw_ptr++] = c;
		} else {
			a = new int[__lookaheadw.length * 2];
			System.arraycopy(__lookaheadw, 0, a, 0,
					__lookaheadw.length);
			__lookaheadw = a;
			__lookaheadw[__lookaheadw_ptr++] = c;
		}
	}

	private void __copy_lookahead(int p) {
		int[] a;

		if(__lookahead_ptr > 0) {
			a = new int[__lookahead.length - __lookahead_ptr];
			System.arraycopy(__lookahead, __lookahead_ptr, a, 0, a.length);
			__lookahead = a;
		}

		if(__lookahead == null) {
			a = new int[__lookaheadw_ptr];
		} else if(__lookaheadw_ptr < __lookahead.length) {
			a = __lookahead;
		} else {
			a = new int[__lookaheadw_ptr];
		}
		System.arraycopy(__lookaheadw, 0, a, 0, __lookaheadw_ptr);
		__lookahead = a;
		__lookahead_ptr = p;
		__lookaheadw = null;
		__lookaheadw_ptr = -1;
	}

	void LOOKAHEAD_COMMIT() {
		if(__lookahead_mark < 0) {
			__lookaheadw = null;
			__lookaheadw_ptr = -1;
		} else {
			__copy_lookahead(__lookahead_mark);
		}
		__lookahead_mark = -1;
		__logprint("Commit Lookahead");
	}

	void LOOKAHEAD_RB() {
		__copy_lookahead(0);
		STATE = __lookahead_state;
		__lookahead_ok = false;
		__lookahead_mark = -1;
		__logprint("Rollback Lookahead");
	}

	void LOOKAHEAD_MARK() {
		__lookahead_mark = __lookaheadw_ptr;
	}

	void LOOKAHEAD_MARK_INIT() {
		__lookahead_mark = 0;
	}


	private int action_step(int  $c)  throws java.io.IOException {
		__lookahead_ok = true;
		switch(STATE) {
		case 0:
			if($c < 0) {
				STATE = 1;
				return 1;
			} else if($c >= 0) {
				UNGET($c);
				STATE = 1;
				return 1;
			}
		case 1:
			if(($c == '\'')) {
				STATE = 2;
				return 1;
			} else if(($c == '"')) {
				STATE = 3;
				return 1;
			} else if(($c >= 0 && $c <= '!') || ($c >= '#' && $c <= '&') || ($c >= '(' && $c <= 'z') || ($c == '|') || ($c >= '~' && $c <= 2147483647)) {
				STATE = 1;
				return 1;
			} else if(($c == '{')) {
				STATE = 4;
				return 1;
			}
			return 0;
		case 4:
				STATE = 5;
				return 1;
		case 5:
			if($c >= 0) {
				__stkpush(6, ENGINE_action);
				STATE = 0;
				return NINA_ACCEPT;
			}
			return 0;
		case 6:
			if(($c == '}')) {
				STATE = 7;
				return 1;
			}
			return 0;
		case 7:
			if(($c >= 0 && $c <= 'z') || ($c == '|') || ($c >= '~' && $c <= 2147483647)) {
				STATE = 7;
				return 1;
			} else if(($c == '{')) {
				STATE = 4;
				return 1;
			}
			return 0;
		case 3:
			if(($c == '"')) {
				STATE = 1;
				return 1;
			} else if(($c == '\\')) {
				STATE = 8;
				return 1;
			} else if($c >= 0) {
				STATE = 3;
				return 1;
			}
			return 0;
		case 8:
			if($c >= 0) {
				STATE = 3;
				return 1;
			}
			return 0;
		case 2:
			if(($c == '\\')) {
				STATE = 9;
				return 1;
			} else if(($c == '\'')) {
				STATE = 1;
				return 1;
			} else if($c >= 0) {
				STATE = 2;
				return 1;
			}
			return 0;
		case 9:
			if($c >= 0) {
				STATE = 2;
				return 1;
			}
			return 0;
		}
		return 0;
	}

	private boolean action_accepted() {
		return (STATE == 0 ||
				STATE == 1 ||
				STATE == 4 ||
				STATE == 7);
	}

	int action_execaction(int  $c) {
		switch(STATE) {
		case 2:
			// State27   
			_b($c);
			break;
		case 7:
			// State26   
			_b($c);
			break;
		case 6:
			break;
		case 8:
			// State30   
			_b($c);
			break;
		case 5:
			break;
		case 0:
			break;
		case 1:
			// State23   
			_b($c);
			break;
		case 4:
			// State24   
			_b($c);
			break;
		case 9:
			// State28   
			_b($c);
			break;
		case 3:
			// State29   
			_b($c);
			break;
		}
		return 1;
	}

	boolean action_isend() {
		return (STATE == 0 ||
				STATE == 4);
	}

	private final Engine ENGINE_action = new Engine() {

		int step(int c) throws java.io.IOException {
			return action_step(c);
		}

		boolean accepted() {
			return action_accepted();
		}

		int execaction(int c) {
			return action_execaction(c);
		}

		boolean isend() {
			return action_isend();
		}

		int recover(Exception e) {
			return -1;
		}

		int deadState() {
			return -1;
		}

		int stateSize() {
			return 10;
		}

		int finallyState() {
			return -1;
		}

		boolean isDead() {
		return false;
		}

		boolean isEmptyTransition() {
		return (STATE == 4);
		}

		public String toString() {
			return "action";
		}

	};

	private int decultureAction_step(int  $c)  throws java.io.IOException {
		boolean __l__ = __lookahead_ok;

		__lookahead_ok = true;
		switch(STATE) {
		case 0:
			if($c < 0) {
				STATE = 1;
				return 1;
			} else if($c >= 0) {
				UNGET($c);
				STATE = 1;
				return 1;
			}
		case 1:
			if(($c >= 9 && $c <= '\n') || ($c == ' ')) {
				STATE = 1;
				return 1;
			} else if(($c >= 'A' && $c <= 'Z') || ($c >= 'a' && $c <= 'z')) {
				STATE = 2;
				return 1;
			}
			return 0;
		case 2:
			if(($c >= 9 && $c <= '\n') || ($c == ' ') || ($c == ':')) {
				UNGET($c);$buffer = new StringBuffer();
				STATE = 3;
				return 1;
			} else if(($c >= '0' && $c <= '9') || ($c >= 'A' && $c <= 'Z') || ($c >= 'a' && $c <= 'z')) {
				STATE = 2;
				return 1;
			}
			return 0;
		case 3:
			if(($c == ':')) {
				$buffer.append((char)$c);
				STATE = 4;
				return 1;
			} else if(($c >= 9 && $c <= '\n') || ($c == ' ')) {
				$buffer.append((char)$c);
				STATE = 5;
				return 1;
			}
			return 0;
		case 5:
			if(($c == ':')) {
				$buffer.append((char)$c);
				STATE = 4;
				return 1;
			} else if(($c >= 9 && $c <= '\n') || ($c == ' ')) {
				$buffer.append((char)$c);
				STATE = 5;
				return 1;
			}
			return 0;
		case 4:
			if(($c >= 0 && $c <= 2147483647)) {
				UNGET($c);
				STATE = 6;
				return 1;
			} else if($c < 0) {
				
				STATE = 6;
				return 1;
			}
			return 0;
		case 6:
			if(($c >= 'A' && $c <= 'Z') || ($c >= 'a' && $c <= 'z')) {
				STATE = 7;
				return 1;
			} else if(($c >= 9 && $c <= '\n') || ($c == ' ')) {
				STATE = 6;
				return 1;
			} else if(($c == '|')) {
				STATE = 8;
				return 1;
			} else if(($c == '{')) {
				STATE = 9;
				return 1;
			} else if(($c == ';')) {
				_ac();
				STATE = 1;
				return 1;
			} else if(($c == '\'')) {
				STATE = 10;
				return 1;
			}
			return 0;
		case 10:
			if(($c == '\\')) {
				STATE = 11;
				return 1;
			} else if($c >= 0) {
				STATE = 12;
				return 1;
			}
			return 0;
		case 12:
			if(($c == '\'')) {
				STATE = 13;
				return 1;
			}
			return 0;
		case 13:
			if((__l__ && $c == '%')) {
				LOOKAHEAD($c);
				STATE = 14;
				return 1;
			} else if(($c >= 'A' && $c <= 'Z') || ($c >= 'a' && $c <= 'z')) {
				STATE = 7;
				return 1;
			} else if(($c == '{')) {
				STATE = 9;
				return 1;
			} else if(($c == '\'')) {
				STATE = 10;
				return 1;
			} else if(($c >= 9 && $c <= '\n') || ($c == ' ')) {
				STATE = 13;
				return 1;
			} else if($c < 0) {
				STATE = 15;
				return 1;
			} else if($c >= 0) {
				UNGET($c);
				STATE = 15;
				return 1;
			}
		case 15:
			if(($c >= 9 && $c <= '\n') || ($c == ' ')) {
				STATE = 15;
				return 1;
			} else if(($c == '|')) {
				STATE = 8;
				return 1;
			} else if(($c == ';')) {
				_ac();
				STATE = 16;
				return 1;
			} else if($c < 0) {
				STATE = 17;
				return 1;
			} else if($c >= 0) {
				UNGET($c);
				STATE = 17;
				return 1;
			}
		case 17:
				STATE = 6;
				return 1;
		case 16:
			if(($c >= 9 && $c <= '\n') || ($c == ' ')) {
				STATE = 16;
				return 1;
			} else if($c < 0) {
				STATE = 1;
				return 1;
			} else if($c >= 0) {
				UNGET($c);
				STATE = 1;
				return 1;
			}
		case 14:
			if((__l__ && $c == 'p')) {
				LOOKAHEAD($c);
				STATE = 18;
				return 1;
			}
			return 0;
		case 18:
			if((__l__ && $c == 'r')) {
				LOOKAHEAD($c);
				STATE = 19;
				return 1;
			}
			return 0;
		case 19:
			if((__l__ && $c == 'e')) {
				LOOKAHEAD($c);
				STATE = 20;
				return 1;
			}
			return 0;
		case 20:
			if(($c == 'c')) {
				LOOKAHEAD_COMMIT();
				STATE = 21;
				return 1;
			}
			return 0;
		case 21:
			if(($c >= 9 && $c <= '\n') || ($c == ' ')) {
				STATE = 21;
				return 1;
			} else if(($c >= 'A' && $c <= 'Z') || ($c >= 'a' && $c <= 'z')) {
				STATE = 22;
				return 1;
			} else if(($c == '\'')) {
				STATE = 23;
				return 1;
			}
			return 0;
		case 23:
			if(($c == '\\')) {
				STATE = 24;
				return 1;
			} else if($c >= 0) {
				STATE = 25;
				return 1;
			}
			return 0;
		case 25:
			if(($c == '\'')) {
				STATE = 26;
				return 1;
			}
			return 0;
		case 26:
				STATE = 13;
				return 1;
		case 24:
			if($c >= 0) {
				STATE = 25;
				return 1;
			}
			return 0;
		case 22:
			if(($c >= '0' && $c <= '9') || ($c >= 'A' && $c <= 'Z') || ($c >= 'a' && $c <= 'z')) {
				STATE = 22;
				return 1;
			} else if($c < 0) {
				STATE = 26;
				return 1;
			} else if($c >= 0) {
				UNGET($c);
				STATE = 26;
				return 1;
			}
		case 11:
			if($c >= 0) {
				STATE = 12;
				return 1;
			}
			return 0;
		case 9:
			if(($c == '}')) {
				STATE = 15;
				return 1;
			} else if($c < 0) {
				STATE = 27;
				return 1;
			} else if($c >= 0) {
				UNGET($c);
				STATE = 27;
				return 1;
			}
		case 27:
			if($c >= 0) {
				__stkpush(28, ENGINE_action);
				STATE = 0;
				return NINA_ACCEPT;
			}
			return 0;
		case 28:
			if(($c == '}')) {
				STATE = 15;
				return 1;
			}
			return 0;
		case 8:
				STATE = 6;
				return 1;
		case 7:
			if(($c >= '0' && $c <= '9') || ($c >= 'A' && $c <= 'Z') || ($c >= 'a' && $c <= 'z')) {
				STATE = 7;
				return 1;
			} else if(($c == '{')) {
				STATE = 9;
				return 1;
			} else if(($c >= 9 && $c <= '\n') || ($c == ' ')) {
				STATE = 13;
				return 1;
			}
			return 0;
		}
		return 0;
	}

	private boolean decultureAction_accepted() {
		return (STATE == 0 ||
				STATE == 16 ||
				STATE == 1);
	}

	int decultureAction_execaction(int  $c) {
		switch(STATE) {
		case 0:
			break;
		case 24:
			// State15    
			_es = true;
			break;
		case 14:
			break;
		case 4:
			break;
		case 26:
			// State22   
			_pr();
			break;
		case 10:
			// State7      
			_es = false;
			break;
		case 7:
			// State6   
			_b($c);
			break;
		case 3:
			break;
		case 5:
			break;
		case 23:
			// State13     
			_es = false;
			break;
		case 12:
			// State8   
			_ch($c);
			break;
		case 19:
			break;
		case 25:
			// State14   
			_ch($c);
			break;
		case 20:
			break;
		case 2:
			// State2   
			_b($c);
			break;
		case 16:
			// State21   
			// none
			break;
		case 22:
			// State12   
			// none
			break;
		case 9:
			// State16   
			_x($c);
			break;
		case 21:
			// State11   
			// none
			break;
		case 28:
			break;
		case 1:
			// State1   
			// none
			break;
		case 27:
			break;
		case 18:
			break;
		case 13:
			// State10   
			_st(0);
			break;
		case 8:
			// State20   
			_ac();
			break;
		case 17:
			// State19   
			_aa();
			break;
		case 6:
			// State4   
			_st($c);
			break;
		case 11:
			// State9     
			_es = true;
			break;
		case 15:
			// State18   
			// none
			break;
		}
		return 1;
	}

	boolean decultureAction_isend() {
		return (STATE == 17 ||
				STATE == 0 ||
				STATE == 16 ||
				STATE == 4 ||
				STATE == 22 ||
				STATE == 8 ||
				STATE == 9 ||
				STATE == 26 ||
				STATE == 13 ||
				STATE == 15);
	}

	private final Engine ENGINE_decultureAction = new Engine() {

		int step(int c) throws java.io.IOException {
			return decultureAction_step(c);
		}

		boolean accepted() {
			return decultureAction_accepted();
		}

		int execaction(int c) {
			return decultureAction_execaction(c);
		}

		boolean isend() {
			return decultureAction_isend();
		}

		int recover(Exception e) {
			return -1;
		}

		int deadState() {
			return -1;
		}

		int stateSize() {
			return 29;
		}

		int finallyState() {
			return -1;
		}

		boolean isDead() {
		return false;
		}

		boolean isEmptyTransition() {
		return (STATE == 17 ||
				STATE == 8 ||
				STATE == 26);
		}

		public String toString() {
			return "decultureAction";
		}

	};

	void __stkpush(int st, Engine en) {
		Object[][] c;
		Engine[] b;
		int[] a;

		if(__slen >= __sts.length) {
			a = new int[__sts.length * 2];
			b = new Engine[__stk.length * 2];
			c = new Object[__stk.length * 2][];
			System.arraycopy(__sts, 0, a, 0, __sts.length);
			System.arraycopy(__stk, 0, b, 0, __stk.length);
			System.arraycopy(__stv, 0, c, 0, __stv.length);
			__sts = a;
			__stk = b;
			__stv = c;
		}
		__sts[__slen] = st;
		__stk[__slen] = en;
		__stv[__slen++] = new Object[en.stateSize()];
	}

	private int _parse(int x, Boolean rt, boolean skip,
			int[] st) throws java.io.IOException {
		boolean b = false, p = skip;
		int c = x;
		Engine en;
		int a;

		b = __stk[__slen - 1].accepted();
		if(rt.booleanValue()) {
			switch(__stk[__slen - 1].execaction(NINA_BEGIN)) {
			case NINA_ACCEPT:
				__logprint("accept " + __stk[__slen - 1]);
				st[0] = NINA_ACCEPT;  return -1;
			case NINA_FAIL:
				__logprint("match failed: begin");
				__puttrace();
				st[0] = NINA_FAIL;  return -1;
			case NINA_HALT_ACCEPT:
				__logprint("machine halted: begin");
				st[0] = NINA_HALT_ACCEPT;  return -1;
			case NINA_HALT_REJECT:
				__logprint("machine halted: begin");
				st[0] = NINA_HALT_REJECT;  return -1;
			case NINA_YIELD:
				__logprint("machine yielded: ", c);
				st[0] = NINA_YIELD;  return -1;
			}
		}

		try {
			do {
				en = __stk[__slen - 1];
				if(p) {
					p = false;
				} else if((a = en.step(c)) > 0) {
					__logprint("transit to state " + STATE + ": ", c);
					b = en.accepted();
					switch(en.execaction(c)) {
					case NINA_ACCEPT:
						__logprint("accept " + __stk[__slen - 1]);
						UNGET(c);
						st[0] = NINA_ACCEPT;  return -1;
					case NINA_FAIL:
						__logprint("match failed: ", c);
						__puttrace();
						UNGET(c);
						st[0] = NINA_FAIL;  return -1;
					case NINA_HALT_ACCEPT:
						__logprint("machine halted: ", c);
						st[0] = NINA_HALT_ACCEPT;  return -1;
					case NINA_HALT_REJECT:
						__logprint("machine halted: ", c);
						st[0] = NINA_HALT_REJECT;  return -1;
					case NINA_YIELD:
						__logprint("machine yielded: ", c);
						st[0] = NINA_YIELD;  return -1;
					}
				} else if(a < 0) {
					__logprint("entering " + __stk[__slen - 1]);
					return c;
				} else if(b) {
					__logprint("accept " + __stk[__slen - 1]);
					UNGET(c);
					st[0] = NINA_ACCEPT;  return -1;
				} else if(__lookaheadw_ptr >= 0) {
					__logprint("match failed: try lookahead: ", c);
					LOOKAHEAD(c);
					LOOKAHEAD_RB();
					b = en.accepted();
				} else if(c == -1) {
					if(!b)  throw new TokenException();
					st[0] = NINA_ACCEPT;
					return -1;
				} else {
					__logprint("match failed: ", c);
					__puttrace();
					UNGET(c);
					st[0] = NINA_FAIL;  return -1;
				}

				if(__stk[__slen - 1].isEmptyTransition()) {
					// do nothing
				} else if(!__stk[__slen - 1].isDead()) {
					c = _read();
				} else if(b) {
					__logprint("accept " + __stk[__slen - 1]);
					st[0] = NINA_ACCEPT;  return -1;
				} else if(__lookaheadw_ptr >= 0) {
					__logprint("match failed: try lookahead: ", c);
					LOOKAHEAD_RB();
					b = en.accepted();
				} else {
					__logprint("match failed: ", c);
					__puttrace();
					st[0] = NINA_FAIL;  return -1;
				}
			} while(true);
		} catch(RuntimeException e) {
			UNGET(c);
			throw e;
		}
	}

	private Boolean execfinally() {
		int a, b;

		if((a = __stk[__slen - 1].finallyState()) >= 0) {
			b = STATE;  STATE = a;
			switch(__stk[__slen - 1].execaction(NINA_BEGIN)) {
			case NINA_HALT_ACCEPT:
				__slen = 0;
				return Boolean.TRUE;
			case NINA_HALT_REJECT:
				__slen = 0;
				return Boolean.FALSE;
			}
			STATE = b;
		}
		return null;
	}

	private int getdeadstate() {
		return __stk[__slen - 1].deadState();
	}

	private int getrecover(Exception e) {
		return __stk[__slen - 1].recover(e);
	}

	boolean parse(Engine entry) throws java.io.IOException {
		Boolean b = Boolean.FALSE;
		int[] a = new int[1];
		boolean skip = true;
		int c = 0;

		__logopen();
		try {
			if(__slen == 0) {
				b = Boolean.TRUE;
				__stkpush(0, entry);
			}

			ot: while(true) {
				try {
					if((c = _parse(c, b, skip, a)) != -1) {
						skip = false;
					} else if(a[0] == NINA_FAIL) {
						while((STATE = getdeadstate()) < 0) {
							if((b = execfinally()) != null)  break ot;
							if(__slen-- <= 1) {
								throw new TokenException();
							}
						}
						skip = true;
					} else if(a[0] == NINA_HALT_ACCEPT) {
						if((b = execfinally()) != null)  break;
						__slen = 0;
						b = Boolean.TRUE;  break;
					} else if(a[0] == NINA_HALT_REJECT) {
						if((b = execfinally()) != null)  break;
						__slen = 0;
						b = Boolean.FALSE;  break;
					} else if(a[0] == NINA_YIELD) {
						return false;
					} else if(__slen > 1) {
						if((b = execfinally()) != null)  break;
						STATE = __sts[--__slen];
						skip = true;
					} else {
						if((b = execfinally()) != null)  break;
						b = new Boolean(__stk[--__slen].accepted());
						break;
					}
				} catch(RuntimeException e) {
					exception = e;
					if(__slen <= 0)  throw e;
					while((STATE = getrecover(e)) < 0) {
						if((b = execfinally()) != null)  return b;
						if(__slen-- <= 1)  throw e;
					}
				}
				b = Boolean.TRUE;
			}
			if(!b.booleanValue())  throw new TokenException();
			return b.booleanValue();
		} finally {
			__logclose();
		}
	}

	boolean parse(java.io.Reader rd) throws java.io.IOException {
		streamStack.push(rd);
		return parse(ENGINE_decultureAction);
	}

	void setStream(java.io.Reader rd) {
		if(streamStack.size() == 0) {
			throw new IllegalStateException();
		}
		yieldObject = rd;
		streamStack.push(rd);
	}

	Object parseNext() throws java.io.IOException {
		Object o;

		if(streamStack.size() == 0) {
			throw new IllegalStateException();
		} else if(yieldObject == null) {
			return null;
		} else if(parse(ENGINE_decultureAction)) {
			if(yieldObject == null)  throw new NullPointerException();
			o = yieldObject;  yieldObject = null;
			return o;
		} else {
			if(yieldObject == null)  throw new NullPointerException();
			return yieldObject;
		}
	}

	static void puts(String s) {
		System.out.println(s);
	}

	boolean parse(java.io.InputStream rd) throws java.io.IOException {
		return parse(new java.io.InputStreamReader(rd));
	}

	/* @@@-PARSER-CODE-END-@@@ */
	private Map<String, String> tokens;
	private Map<ContextFreeRule, Object> actions = new HashMap<ContextFreeRule, Object>();
	private Map<ContextFreeRule, Terminal> prec = new HashMap<ContextFreeRule, Terminal>();
	private List<Object> rule = new ArrayList<Object>();
	private StringBuffer buf = new StringBuffer();
	private Object former;
	private int _ch = -1;
	private Terminal tmpp;
	private boolean _es = false;

	public DecultureAction(DecultureDefinition d) {
		tokens = d.getTokens();
	}

	public Map<ContextFreeRule, Object> getActions() {
		return Collections.unmodifiableMap(actions);
	}

	public Map<ContextFreeRule, Terminal> getPrecedences() {
		return Collections.unmodifiableMap(prec);
	}

	private void _b(int c) {
		if(c >= 0)  buf.appendCodePoint(c);
	}

	private void _st(int c) {
		if(rule == null)  rule = new ArrayList<Object>();
		if(c == '|') {
			rule.add(former);
		} else if(_ch >= 0) {
			rule.add(Integer.valueOf(_ch));
			_ch = -1;
		} else if(buf.length() > 0) {
			rule.add(buf.toString());
			buf = new StringBuffer();
		}
	}

	private void _x(int c) {
		_st(0);
		_b(c);
	}

	private void _pr() {
		if(_ch >= 0) {
			tmpp = new CharacterTerminal(_ch);
		} else if(buf.length() > 0) {
			tmpp = new ConstantTerminal(buf.toString());
		}
	}

	private void _aa() {
		ContextFreeRule r;
		Nonterminal l;

		l = ConstantNonterminal.gensym();
		r = new ContextFreeRule(l, new GrammarSymbol[0]);
		rule.add(l);
		actions.put(r, buf.append('}').toString());
		_ch = -1;
		buf = new StringBuffer();
	}

	private void _ac() {
		Nonterminal l;
		GrammarSymbol[] a;
		GrammarSymbol g;
		ContextFreeRule r;
		Object o;

		if(rule == null) {
			return;
		} else if(tokens.containsKey(rule.get(0))) {
			throw new DecultureException();
		}
		l = new ConstantNonterminal(rule.get(0).toString());

		a = new GrammarSymbol[rule.size() - 1];
		for(int k = 1; k < rule.size(); k++) {
			if((o = rule.get(k)).equals("error")) {
				g = ConstantTerminal.ERROR;
			} else if(o instanceof Integer) {
				g = new CharacterTerminal(((Integer)o).intValue());
			} else if(tokens.containsKey(o)) {
				g = new ConstantTerminal(o.toString());
			} else if(o instanceof Nonterminal) {
				g = (Nonterminal)o;
			} else {
				g = new ConstantNonterminal(o.toString());
			}
			a[k - 1] = g;
		}
		r = new ContextFreeRule(l, a);

		if(tmpp != null)  prec.put(r, tmpp);
		if(buf.length() > 0) {
			actions.put(r, buf.append('}').toString());
			buf = new StringBuffer();
		} else {
			actions.put(r, null);
		}
		former = rule.get(0);
		rule = null;
		tmpp = null;
	}

	private void _ch(int c) {
		if(!_es) {
			_ch = c;
		} else if(c == 'n') {
			_ch = '\n';
		} else if(c == 'r') {
			_ch = '\r';
		} else if(c == 't') {
			_ch = '\t';
		} else if(c == 'b') {
			_ch = '\b';
		} else if(c == 'f') {
			_ch = '\f';
		} else {
			_ch = c;
		}
	}

	public boolean parseAction(java.io.Reader rd) throws java.io.IOException {
		return parse(new RemoveCCommentReader(rd));
	}

}
