/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sh;

import java.io.InputStream;
import java.io.PrintStream;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/10/25
 */
public abstract class DefaultShVirtualResouceFile implements ShFile {

	private ShFile parent;
	private String current;
	private String rpath;

	public DefaultShVirtualResouceFile(ShFile parentDir,
			String currentName, String resPath) {
		parent  = parentDir;
		current = currentName;
		rpath   = resPath;
	}

	public InputStream getInputStream() {
		return DefaultShVirtualResouceFile.class.getResourceAsStream(
				rpath);
	}

	public String getName() {
		return current;
	}

	public PrintStream getPrintStream(boolean append) {
		return null;
	}

	public boolean isDirectory() {
		return true;
	}

	public boolean isExecutable() {
		return true;
	}

	public boolean isExist() {
		return true;
	}

	public boolean isFile() {
		return false;
	}

	public long getLastModified() {
		return Long.MIN_VALUE;
	}

	public boolean isReadable() {
		return true;
	}

	public boolean isWritable() {
		return false;
	}

	public boolean isHidden() {
		return false;
	}

	public boolean isZeroFile() {
		return false;
	}

	public ShProcess getProcess() {
		return null;
	}

	public ShFile toAbsolute() {
		return this;
	}

	public ShFile toCanonical() {
		return this;
	}

	public boolean mkdir() {
		return false;
	}

	public boolean renameTo(ShFile f) {
		return false;
	}

	public void setLastModified(long time) {
		// do nothing
	}

	public boolean rmdir() {
		return false;
	}

	public boolean deleteFile() {
		return false;
	}

	public ShStat getStat() {
		return new ShStat(toString(), 0, 0, ShStat.READABLE);
	}

	public String toString() {
		return parent.toString() + "/" + current;
	}

}
