/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sh;

import java.util.ArrayList;
import java.util.List;

import net.morilib.sh.ShFile;
import net.morilib.sh.ShFileSystem;

/**
 * 
 *
 *
 * @author MORIGUCHI, Yuichiro 2014/01/02
 */
public abstract class AbstractShFile implements ShFile {

	/**
	 * 
	 */
	protected ShFileSystem filesystem;

	/**
	 * 
	 */
	protected String virtualpath;

	/**
	 * 
	 * @param fs
	 * @param virtualpath
	 */
	public AbstractShFile(ShFileSystem fs, String virtualpath) {
		this.filesystem  = fs;
		this.virtualpath = virtualpath;
	}

	public ShFile toAbsolute() {
		if(virtualpath.equals("/")) {
			return filesystem.getRoot();
		} else if(virtualpath.length() > 0 &&
				virtualpath.charAt(0) == '/') {
			return filesystem.getFile(virtualpath);
		} else {
			return filesystem.getFile(
					filesystem.getCurrentDirectory().toString(),
					virtualpath);
		}
	}

	public ShFile toCanonical() {
		List<String> l = new ArrayList<String>();
		StringBuffer b = new StringBuffer("");
		String[] a;

		if(virtualpath.equals("/"))  return filesystem.getRoot();
		a = toAbsolute().toString().replaceFirst("/+", "").split("/");
		for(String t : a) {
			if(t.equals(".")) {
				// do nothing
			} else if(!t.equals("..")) {
				l.add(t);
			} else if(l.size() > 0) {
				l.remove(l.size() - 1);
			}
		}
		for(String t : l)  b.append("/").append(t);
		return filesystem.getFile(b.toString());
	}

	public String toString() {
		return virtualpath;
	}

}
