/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;
import net.morilib.sh.AbstractShFile;
import net.morilib.sh.ShFile;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShProcess;
import net.morilib.sh.ShStat;
import net.morilib.sh.misc.FileTypeUtils;

public class ShRealFile
extends AbstractShFile {
    protected File file;

    public ShRealFile(ShFileSystem fs, String virtualpath, File file) {
        super(fs, virtualpath);
        this.file = file;
    }

    public File getRealFile() {
        return this.file;
    }

    @Override
    public Collection<ShFile> getFiles() {
        String[] a = this.file.list();
        if (a == null) {
            return Collections.emptyList();
        }
        ArrayList<ShFile> l = new ArrayList<ShFile>();
        TreeSet<String> z = new TreeSet<String>(Arrays.asList(a));
        for (String s : z) {
            ShFile f = this.filesystem.getFile(this.virtualpath, s);
            l.add(f);
        }
        return l;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public PrintStream getPrintStream(boolean append) throws IOException {
        return new PrintStream(new FileOutputStream(this.file, append));
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public boolean isExecutable() {
        if (this.file.isDirectory()) {
            return true;
        }
        if (this.file.isFile()) {
            return FileTypeUtils.parseShebang(this) != null;
        }
        return false;
    }

    @Override
    public boolean isExist() {
        return this.file.exists();
    }

    @Override
    public boolean isFile() {
        return this.file.isFile();
    }

    @Override
    public long getLastModified() {
        return this.file.lastModified();
    }

    @Override
    public boolean isReadable() {
        return this.file.canRead();
    }

    @Override
    public boolean isWritable() {
        return this.file.canWrite();
    }

    @Override
    public boolean isHidden() {
        return this.file.isHidden();
    }

    @Override
    public boolean isZeroFile() {
        return this.file.length() == 0L;
    }

    @Override
    public boolean mkdir() {
        return this.file.mkdir();
    }

    @Override
    public boolean renameTo(ShFile f) {
        return false;
    }

    @Override
    public void setLastModified(long time) {
        this.file.setLastModified(time);
    }

    @Override
    public boolean rmdir() {
        return this.file.isDirectory() && this.file.delete();
    }

    @Override
    public boolean deleteFile() {
        return this.file.isFile() && this.file.delete();
    }

    public static ShStat getStat(ShFile t, String virtualpath, File file) {
        ShStat r = new ShStat();
        int f = 0;
        r.setFilename(virtualpath);
        r.setMtime(file.lastModified());
        r.setSize(file.length());
        f |= t.isDirectory() ? 8 : 0;
        f |= t.isExecutable() ? 4 : 0;
        f |= t.isWritable() ? 2 : 0;
        r.setFlags(f |= t.isReadable() ? 1 : 0);
        return r;
    }

    @Override
    public ShStat getStat() {
        return ShRealFile.getStat(this, this.virtualpath, this.file);
    }

    @Override
    public ShProcess getProcess() {
        return null;
    }

    @Override
    public String toString() {
        return this.virtualpath;
    }
}

