unit plottext;
{$IFDEF FPC}
  {$MODE DELPHI}{$H+}
{$ENDIF}
(***************************************)
(* Copyright (C) 2013, SHIRAISHI Kazuo *)
(***************************************)


interface



implementation
uses SysUtils,Classes,
     listcoll,base,base0,texthand,variabl,struct,express, print,
     graphic,helpctex{,graphsys};

type
     TSetTextJustify=class(TStatement)
          exp1:TPrincipal;
          exp2:TPrincipal;
        constructor create(prev,eld:TStatement);
        destructor destroy;override;
        //procedure exec;override;
        function code:ansistring;override;
      end;

constructor TSetTextJustify.create(prev,eld:TStatement);
begin
   inherited create(prev,eld);
   exp1:=SExpression;
   check(',',IDH_SET_TEXT_JUSTIFY);
   exp2:=SExpression;
end;

destructor TSetTextJustify.destroy;
begin
     exp1.free;
     exp2.free;
    inherited destroy
end;

(*
procedure TSetTextJustify.exec;
var
   s1,s2:ansistring;
begin
   s1:=exp1.evalS;
   s2:=exp2.evalS;

    s1:=ansiUpperCase(s1);
    s2:=ansiUpperCase(s2);

    SetTextJustify(s1,s2, insideOfWhen);

end;
*)
function SetTextJustifyst(prev,eld:TStatement):TStatement;
begin
   SetTextJustifyst:=TSetTextJustify.create(prev,eld)
end;


type
   TPlotText=class(TStatement)
         exp1,exp2,exp3:TPrincipal;
         image:TPrincipal;
         items:TListCollection;
         GraphStm:boolean;
         LabelStm:boolean;
         LettersStm:boolean;

     constructor create(prev,eld:TStatement);
     destructor destroy;override;
     //procedure exec;override;
     function Code:ansistring;override;
    private
     //function formatted:ansistring;
   end;


function PlotTextst(prev,eld:TStatement):TStatement;
begin
    PlotTextst:=TPlotText.create(prev,eld);
end;



constructor TPLotText.create(prev,eld:TStatement); //2011.3.5
begin
   inherited create(prev,eld);
   GraphStm:=(prevToken='GRAPH');
   LabelStm:=(Token='LABEL');
   LettersStm:=(Token='LETTERS') or TextPhysicalCoordinate and not LabelStm;
   gettoken;
   check(',',IDH_TEXT);
   check('AT',IDH_TEXT);
   exp1:=NEXpression;
   if (programunit.Arithmetic=PrecisionComplex)
       and ((token=':') or (token=',') and (nexttoken='USING')
                           and not((nextnexttoken=',') or (nextnexttoken=':'))) then
      //  複素座標
   else
      begin
        check(',',IDH_TEXT);
        exp2:=NExpression;
      end;
   if test(',') then
      begin
         CheckToken('USING',IDH_TEXT);
         image:=ImageRef;
         checkToken(':',IDH_PRINT_USING);
         items:=TListCollection.create;
         repeat
             items.insert(NSExpression);
         until test(',')=false;
      end
   else
      begin
       check(':',IDH_TEXT);
       exp3:=SExpression;
      end;
end;



destructor TPLotText.destroy;
begin
     exp1.free;
     exp2.free;
     exp3.free;
   items.free;
   image.free;
    inherited destroy
end;


(*
procedure TPlotText.exec;
var
   n,m:extended;
   s:ansistring;
begin
   with MyGraphSys do
      if BeamMode=bmRigorous then beam:=false;
   n:=exp1.evalX;
   m:=exp2.evalX;
   if exp3<>nil then
       s:=exp3.evalS
   else
       s:=Formatted;
   if GraphStm then
      MyGraphSys.puttext(n,m,s)
   else if currentTransform.transform(n,m) then
      if LabelStm then
         MyGraphSys.puttext(n,m,s)
      else
         MyGraphSys.Plottext(n,m,s)
end;
*)

(*
function TPlotText.formatted:ansistring;
var
   form:ansistring;
   c,i,code:integer;
begin
   result:='';
   if image<>nil then
     form:=image.evalS;
   i:=1;
   result:=literals(form,i);
   c:=0;
   while (c<items.count) do
      begin
        result:=result + TPrincipal(items.items[c]).format(form,i,code);
        inc(c);
        result:=result +literals(form,i)
      end;
end;
*)

function TPlotText.Code:ansistring;
var
  c:integer;
  s:ansistring;
begin
  if exp2<>nil then
      if exp3<>nil then
        begin
           if GraphStm then
               if LabelStm then
                 result:='GraphLabel('+exp1.code+','+exp2.code+','+exp3.code+');'
               else
                 result:='GraphText('+exp1.code+','+exp2.code+','+exp3.code+');'
           else
               if LabelStm then
                 result:='PlotLabel('+exp1.code+','+exp2.code+','+exp3.code+');'
               else if LettersStm then
                 result:='PlotLetters('+exp1.code+','+exp2.code+','+exp3.code+');'
               else
                 result:='PlotText('+exp1.code+','+exp2.code+','+exp3.code+');'
        end
      else
         begin
            if GraphStm then
               if LabelStm then
                 result:='GraphLabelUsing('+exp1.code+','+exp2.code+','+image.code +',['
               else
                 result:='GraphTextUsing('+exp1.code+','+exp2.code+','+image.code +',['
            else
               if LabelStm then
                 result:='PlotLabelUsing('+exp1.code+','+exp2.code+','+image.code +',['
               else if LettersStm then
                 result:='PlotLettersUsing('+exp1.code+','+exp2.code+','+image.code +',['
               else
                 result:='PlotTextUsing('+exp1.code+','+exp2.code+','+image.code +',[';

            for c:=0 to items.count-1 do
               begin
                 if c>0 then result:=result+',';
                 s:=TPrincipal(items.items[c]).code;
                 if (TPrincipal(items.items[c]).kind='n')
                     and (PUnit.Arithmetic=precisionComplex) then
                     s:='testreal('+s+')'
                 else if (TPrincipal(items.items[c]).kind='n')
                     and (PUnit.Arithmetic=precisionNormal) then
                     s:='ExtendedVal('+s+')';
                 result:=result+s;
               end;
             result:=result+']);'
         end
  else
       if exp3<>nil then
        begin
           if GraphStm then
               if LabelStm then
                 result:='GraphLabelComplex('+exp1.code+','+exp3.code+');'
               else
                 result:='GraphTextComplex('+exp1.code+','+exp3.code+');'
           else
               if LabelStm then
                 result:='PlotLabelComplex('+exp1.code+','+exp3.code+');'
               else if LettersStm then
                 result:='PlotLettersComplex('+exp1.code+','+exp3.code+');'
               else
                 result:='PlotTextComplex('+exp1.code+','+exp3.code+');'
        end
      else
         begin
            if GraphStm then
               if LabelStm then
                 result:='GraphLabelUsingComplex('+exp1.code+','+image.code +',['
               else
                 result:='GraphTextUsingComplex('+exp1.code+','+image.code +',['
            else
               if LabelStm then
                 result:='PlotLabelUsingComplex('+exp1.code+','+image.code +',['
               else if LettersStm then
                 result:='PlotLettersUsingComplex('+exp1.code+','+image.code +',['
               else
                 result:='PlotTextUsingComplex('+exp1.code+','+image.code +',[';

            for c:=0 to items.count-1 do
               begin
                 if c>0 then result:=result+',';
                 s:=TPrincipal(items.items[c]).code;
                 if (TPrincipal(items.items[c]).kind='n')
                     and (PUnit.Arithmetic=precisionComplex) then
                     s:='testreal('+s+')';
                 result:=result+s;
               end;
             result:=result+']);'
         end
end;


function TSetTextJustify.code:ansistring;
begin
   result:='SetTextJustify('+exp1.code+','+exp2.code+','+TruthLiteral(insideofwhen)+');'
end;



begin
   graphic.settextjustifyst:=settextjustifyst;
   graphic.plottextst:=plottextst;
end.
