/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.popup;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IObjectActionDelegate;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.ui.jobs.ScriptExecJob;
import zigen.plugin.db.ui.popup.ExecSQLFileAction;
import zigen.plugin.db.ui.popup.Messages;
import zigen.plugin.db.ui.util.FileUtil;
import zigen.plugin.db.ui.util.ResourceUtil;

public class ExecScriptFileAction
extends ExecSQLFileAction
implements IObjectActionDelegate {
    public void run(IAction action) {
        try {
            if (this.file != null) {
                IDBConfig config = ResourceUtil.getDBConfig((IResource)this.file);
                if (config != null) {
                    String sql = FileUtil.getContents(this.file);
                    if (sql != null && sql.trim().length() > 0) {
                        Transaction trans = Transaction.getInstance(config);
                        ScriptExecJob job = new ScriptExecJob(trans, sql, null);
                        job.setUser(false);
                        job.schedule();
                    } else {
                        DbPlugin.getDefault().showInformationMessage(Messages.getString("ExecSQLFileAction.0"));
                    }
                } else {
                    DbPlugin.getDefault().showInformationMessage(Messages.getString("ExecSQLFileAction.1"));
                }
            }
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }
}

