/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.actions;

import java.sql.Connection;
import java.util.Iterator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.DeleteSQLInvoker;
import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.core.TableElement;
import zigen.plugin.db.core.TimeWatcher;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.core.TransactionForTableEditor;
import zigen.plugin.db.ui.actions.Messages;
import zigen.plugin.db.ui.actions.TableViewEditorAction;
import zigen.plugin.db.ui.editors.ITableViewEditor;
import zigen.plugin.db.ui.editors.internal.TableViewerManager;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.jobs.RecordCountForTableJob;

public class DeleteRecordAction
extends TableViewEditorAction {
    protected IStructuredSelection selection;

    public DeleteRecordAction() {
        this.setEnabled(false);
        this.setImage(6);
    }

    public void refresh() {
        if (this.editor == null) {
            this.setEnabled(false);
        } else if (this.editor.getViewer() == null) {
            this.setEnabled(false);
        } else {
            this.selection = (IStructuredSelection)this.editor.getViewer().getSelection();
            if (this.selection.size() > 0) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    public void run() {
        int rowAffected = 0;
        try {
            TimeWatcher tw = new TimeWatcher();
            tw.start();
            ITable table = this.editor.getTableNode();
            TransactionForTableEditor trans = TransactionForTableEditor.getInstance(table.getDbConfig());
            Connection con = trans.getConnection();
            IStructuredSelection selection = (IStructuredSelection)this.editor.getViewer().getSelection();
            Iterator iter = selection.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!(obj instanceof TableElement)) continue;
                TableElement elem = (TableElement)obj;
                if (elem.isNew()) {
                    ++rowAffected;
                    continue;
                }
                TableColumn[] uniqueColumns = elem.getUniqueColumns();
                Object[] uniqueItems = elem.getUniqueItems();
                int row = DeleteSQLInvoker.invoke(con, table, uniqueColumns, uniqueItems);
                rowAffected += row;
            }
            tw.stop();
            if (DbPlugin.getDefault().confirmDialog(String.valueOf(rowAffected) + Messages.getString("DeleteRecordAction.0"))) {
                trans.commit();
                this.removeElement(selection);
            } else {
                trans.rollback();
            }
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }

    private void removeElement(IStructuredSelection selection) {
        ITableViewEditor editor = DbPlugin.getActiveTableViewEditor();
        if (editor == null) {
            throw new IllegalStateException("TableViewer not found");
        }
        TableViewer viewer = editor.getViewer();
        TableViewerManager.remove(viewer, selection.toArray());
        TableElement[] elements = (TableElement[])viewer.getInput();
        int dispCnt = elements.length - 1;
        editor.setTotalCount(dispCnt, -1L);
        ITable tableNode = editor.getTableNode();
        String condition = editor.getCondition();
        RecordCountForTableJob job2 = new RecordCountForTableJob(Transaction.getInstance(this.config), tableNode, condition, dispCnt, true);
        job2.setUser(false);
        job2.schedule();
    }
}

