/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ext.oracle.internal;

import java.sql.Connection;
import java.util.ArrayList;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.core.rule.DefaultColumnSearcherFactory;
import zigen.plugin.db.core.rule.IColumnSearcherFactory;
import zigen.plugin.db.ext.oracle.tablespace.OracleTableColumn;
import zigen.plugin.db.ui.internal.Table;

public class OracleTableColumnSearcher {
    public static OracleTableColumn[] execute(IDBConfig config, Table table) throws Exception {
        Connection con = Transaction.getInstance(config).getConnection();
        return OracleTableColumnSearcher.execute(con, table, config.isConvertUnicode());
    }

    public static OracleTableColumn[] execute(Connection con, Table table, boolean convertUnicode) throws Exception {
        try {
            String owner = table.getSchemaName();
            String tableName = table.getName();
            IDBConfig config = table.getDbConfig();
            IColumnSearcherFactory factory = DefaultColumnSearcherFactory.getFactory(con.getMetaData(), config.isConvertUnicode());
            TableColumn[] columns = factory.execute(con, owner, tableName);
            ArrayList<OracleTableColumn> list = new ArrayList<OracleTableColumn>(columns.length);
            int i = 0;
            while (i < columns.length) {
                TableColumn column = columns[i];
                OracleTableColumn col = new OracleTableColumn();
                col.setColumn_name(column.getColumnName());
                col.setColumn_length(column.getColumnSize());
                col.setColumn_type(column.getTypeName());
                col.setColumn_position(column.getSeq());
                list.add(col);
                ++i;
            }
            return list.toArray(new OracleTableColumn[0]);
        }
        catch (Exception e) {
            DbPlugin.log(e);
            throw e;
        }
    }
}

