/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ext.oracle.internal;

import java.sql.Connection;
import java.util.Iterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.ext.oracle.internal.Messages;
import zigen.plugin.db.ext.oracle.internal.OracleSourceDetailInfo;
import zigen.plugin.db.ext.oracle.internal.OracleSourceDetailSearcher;
import zigen.plugin.db.ext.oracle.internal.OracleSourceErrorInfo;
import zigen.plugin.db.ext.oracle.internal.OracleSourceErrorSearcher;
import zigen.plugin.db.ui.editors.sql.SequenceEditorInput;
import zigen.plugin.db.ui.editors.sql.SourceEditorInput;
import zigen.plugin.db.ui.internal.OracleSequence;
import zigen.plugin.db.ui.internal.OracleSource;

public class OpenSourceEdirotAction
extends Action
implements Runnable {
    StructuredViewer viewer = null;

    public OpenSourceEdirotAction(StructuredViewer viewer) {
        this.viewer = viewer;
        this.setText(Messages.getString("OpenSourceEdirotAction.0"));
        this.setToolTipText(Messages.getString("OpenSourceEdirotAction.1"));
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
    }

    public void run() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element instanceof OracleSource) {
                OracleSource source = (OracleSource)element;
                this.openSourceEditor(source);
                continue;
            }
            if (element instanceof OracleSequence) {
                OracleSequence seq = (OracleSequence)element;
                this.openSequenceEditor(seq);
                continue;
            }
            throw new IllegalStateException("OpenSourceEdirotAction#run()");
        }
    }

    protected void openSourceEditor(OracleSource source) {
        OracleSourceDetailInfo sourceDetail = null;
        OracleSourceErrorInfo[] sourceErrors = null;
        try {
            Connection con = Transaction.getInstance(source.getDbConfig()).getConnection();
            String owner = source.getOracleSourceInfo().getOwner();
            String type = source.getOracleSourceInfo().getType();
            String name = source.getOracleSourceInfo().getName();
            sourceDetail = OracleSourceDetailSearcher.execute(con, owner, name, type, true);
            sourceErrors = OracleSourceErrorSearcher.execute(con, owner, name, type);
            SourceEditorInput input = new SourceEditorInput(source.getDbConfig(), source, sourceDetail, sourceErrors);
            IWorkbenchPage page = DbPlugin.getDefault().getPage();
            IDE.openEditor((IWorkbenchPage)page, (IEditorInput)input, (String)"zigen.plugin.db.ui.editors.sql.SourceEditor", (boolean)true);
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }

    protected void openSequenceEditor(OracleSequence seq) {
        try {
            SequenceEditorInput input = new SequenceEditorInput(seq.getDbConfig(), seq.getOracleSequenceInfo());
            IWorkbenchPage page = DbPlugin.getDefault().getPage();
            IDE.openEditor((IWorkbenchPage)page, (IEditorInput)input, (String)"zigen.plugin.db.ui.editors.sql.SequenceEditor", (boolean)true);
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }
}

