/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.diff;

import zigen.plugin.db.diff.DDL;
import zigen.plugin.db.diff.DDLNode;
import zigen.plugin.db.diff.IDDL;

public class DDLDiff
extends DDLNode {
    private static final long serialVersionUID = 1L;
    DDL leftDDL;
    IDDL rightDDL;

    public DDLDiff(DDL leftContent, DDL rightContent) {
        this.leftDDL = leftContent;
        this.rightDDL = rightContent;
        if (leftContent != null) {
            this.name = leftContent.targetName;
        }
        if (rightContent != null) {
            this.name = rightContent.targetName;
        }
    }

    public int getResultType() {
        if (this.leftDDL != null && this.rightDDL != null) {
            if (this.leftDDL.getDdl().equals(this.rightDDL.getDdl())) {
                return 40;
            }
            return 30;
        }
        if (this.leftDDL == null) {
            return 20;
        }
        if (this.rightDDL == null) {
            return 10;
        }
        return 99;
    }

    public String getName() {
        if (this.leftDDL != null) {
            return this.leftDDL.getTargetName();
        }
        return this.rightDDL.getTargetName();
    }

    public String getLeftDDLString() {
        if (this.leftDDL != null) {
            return this.leftDDL.ddl;
        }
        return null;
    }

    public String getRightDDLString() {
        if (this.rightDDL != null) {
            return this.rightDDL.getDdl();
        }
        return null;
    }

    public String getLeftDisplayedName() {
        if (this.leftDDL == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append(this.getLeftDBName());
        sb.append("] ");
        sb.append(this.leftDDL.getDisplayedName());
        return sb.toString();
    }

    public String getRightDisplayedName() {
        if (this.rightDDL == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append(this.getRightDBName());
        sb.append("] ");
        sb.append(this.rightDDL.getDisplayedName());
        return sb.toString();
    }

    public String getLeftDBName() {
        if (this.leftDDL == null) {
            return "";
        }
        return this.leftDDL.getDbName();
    }

    public String getRightDBName() {
        if (this.rightDDL == null) {
            return "";
        }
        return this.rightDDL.getDbName();
    }

    public boolean isComparisonFailure() {
        return this.leftDDL != null && this.rightDDL != null;
    }

    public IDDL getLeftDDL() {
        return this.leftDDL;
    }

    public IDDL getRightDDL() {
        return this.rightDDL;
    }

    public String getType() {
        if (this.leftDDL != null) {
            return this.leftDDL.getType();
        }
        return this.rightDDL.getType();
    }
}

