/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import zigen.plugin.db.DbPluginConstant;
import zigen.plugin.db.core.StringUtil;

public class SQLTokenizer
implements Enumeration {
    public static final String LINE_SEP = "\n";
    private String text = null;
    private int currentPosition;
    private int maxPosition;
    private String demiliter;

    public SQLTokenizer(String str, String demiliter) {
        if (str == null || str.length() == 0) {
            return;
        }
        this.text = this.convertLineSep(str);
        this.demiliter = String.valueOf(demiliter) + LINE_SEP;
        if (!this.text.endsWith(LINE_SEP)) {
            this.text = String.valueOf(this.text) + LINE_SEP;
        }
        this.currentPosition = 0;
        this.maxPosition = this.text.length();
    }

    private String convertLineSep(String value) {
        if (value != null && value.length() > 0) {
            value = StringUtil.convertLineSep(value, LINE_SEP);
        }
        return value;
    }

    private boolean hasDemiliter(int fromIndex) {
        if (this.text.startsWith(this.demiliter, fromIndex)) {
            return !this.text.startsWith("*/", fromIndex - 1);
        }
        return false;
    }

    private int nextDemiliter(int i) {
        boolean flg = false;
        while (i < this.maxPosition) {
            char ch = this.text.charAt(i);
            int pos = -1;
            if (this.hasDemiliter(i)) {
                pos = this.text.indexOf(this.demiliter, i);
            }
            if (!flg && pos == i) break;
            if ('\'' == ch) {
                flg = !flg;
            }
            ++i;
        }
        return i;
    }

    public int getTokenCount() {
        if (this.text == null) {
            return 0;
        }
        int i = 0;
        int ret = 1;
        while ((i = this.nextDemiliter(i)) < this.maxPosition) {
            ++i;
            ++ret;
        }
        return ret;
    }

    public String nextToken() {
        if (this.currentPosition > this.maxPosition) {
            throw new NoSuchElementException(this.toString());
        }
        int start = this.currentPosition;
        this.currentPosition = this.nextDemiliter(this.currentPosition);
        StringBuffer sb = new StringBuffer();
        while (start < this.currentPosition) {
            char ch = this.text.charAt(start++);
            sb.append(ch);
        }
        this.currentPosition += this.demiliter.length();
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        String out = sb.toString().trim();
        if (out.length() == 0) {
            return null;
        }
        return StringUtil.convertLineSep(out, DbPluginConstant.LINE_SEP);
    }

    public Object nextElement() {
        return this.nextToken();
    }

    public boolean hasMoreElements() {
        return this.nextDemiliter(this.currentPosition) <= this.maxPosition;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[SQLTokenizer:");
        buffer.append(" text: ");
        buffer.append(this.text);
        buffer.append(" currentPosition: ");
        buffer.append(this.currentPosition);
        buffer.append(" maxPosition: ");
        buffer.append(this.maxPosition);
        buffer.append("]");
        return buffer.toString();
    }
}

