/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.views.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kry.sql.format.SqlFormatRule;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.ImageCacher;
import zigen.plugin.db.parser.util.CurrentSql;
import zigen.plugin.db.ui.editors.sql.SqlEditor2;
import zigen.plugin.db.ui.jobs.AbstractJob;
import zigen.plugin.db.ui.views.internal.SQLSourceViewer;
import zigen.sql.parser.ASTVisitor2;
import zigen.sql.parser.ASTVisitorToString;
import zigen.sql.parser.INode;
import zigen.sql.parser.ISqlParser;
import zigen.sql.parser.IVisitor;
import zigen.sql.parser.Node;
import zigen.sql.parser.SqlParser;
import zigen.sql.parser.ast.ASTAlias;
import zigen.sql.parser.ast.ASTColumn;
import zigen.sql.parser.ast.ASTComma;
import zigen.sql.parser.ast.ASTFunction;
import zigen.sql.parser.ast.ASTInnerAlias;
import zigen.sql.parser.ast.ASTParentheses;
import zigen.sql.parser.ast.ASTSelectStatement;
import zigen.sql.parser.ast.ASTTable;
import zigen.sql.parser.ast.ASTValue;
import zigen.sql.parser.exception.ParserException;

public class SQLOutinePage
extends ContentOutlinePage
implements ISelectionListener {
    SqlEditor2 editor;
    SQLSourceViewer fSQLSourceViewer;
    SqlInput fSqlInput = new SqlInput();
    IDoubleClickListener doubleClickListener;
    SqlParser fSqlParser;
    ASTVisitor2 visitor;
    IDocument fDocument;
    TreeViewer fTreeViewer;
    IPreferenceStore ps;
    CurrentSql currentSql;
    boolean isASTMode = false;
    private Menu fMenu;

    public SQLOutinePage(SqlEditor2 editor) {
        this.editor = editor;
        this.fSQLSourceViewer = editor.getSqlViewer();
        this.fDocument = editor.getSqlViewer().getDocument();
        this.ps = DbPlugin.getDefault().getPreferenceStore();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.fTreeViewer = this.getTreeViewer();
        this.fTreeViewer.setContentProvider((IContentProvider)new TreeContentProvider());
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
        this.doubleClickListener = new DoubleClickListener();
        this.fTreeViewer.addDoubleClickListener(this.doubleClickListener);
        this.fTreeViewer.setUseHashlookup(true);
        this.fTreeViewer.setInput((Object)this.fSqlInput);
        this.fTreeViewer.expandToLevel(2);
        this.update();
        MenuManager manager = new MenuManager("SQLOutlinePage", "SQLOutlinePage");
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager m) {
                SQLOutinePage.this.contextMenuAboutToShow(m);
            }
        });
        this.fMenu = manager.createContextMenu(this.fTreeViewer.getControl());
        this.fTreeViewer.getControl().setMenu(this.fMenu);
        IPageSite site = this.getSite();
        site.registerContextMenu("DBViewer.outline", manager, (ISelectionProvider)this.fTreeViewer);
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
    }

    protected void contextMenuAboutToShow(IMenuManager menu) {
        IStructuredSelection cfr_ignored_0 = (IStructuredSelection)this.getSelection();
        menu.add((IContributionItem)new Separator("additions"));
    }

    public void update() {
        int offset = this.fSQLSourceViewer.getTextWidget().getCaretOffset();
        String _temp = this.currentSql != null ? this.currentSql.getSql() : null;
        String demiliter = this.ps.getString("SQLEditorPreferencePage.SqlDemiliter");
        this.currentSql = new CurrentSql(this.fDocument, offset, demiliter);
        if (_temp == null || !_temp.equals(this.currentSql.getSql())) {
            UpdateOutlineJob job = new UpdateOutlineJob(this.currentSql);
            job.setPriority(30);
            job.setUser(false);
            job.schedule();
        }
    }

    private void revealRange(int offset, int length) {
        this.fSQLSourceViewer.revealRange(offset += this.currentSql.getBegin(), length);
        this.fSQLSourceViewer.setSelectedRange(offset, length);
    }

    public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
        toolBarManager.add((IAction)new ExpandAllAction());
        toolBarManager.add((IAction)new CollapseAllAction());
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof TextSelection) {
            TextSelection ts = (TextSelection)selection;
            if (this.currentSql.getBegin() <= ts.getOffset() && ts.getOffset() <= this.currentSql.getEnd()) {
                if (ts.getText().length() > 0 && this.visitor != null) {
                    try {
                        int searchOffset = ts.getOffset() - this.currentSql.getBegin();
                        INode cNode = this.visitor.findNodeByOffset(searchOffset, ts.getLength());
                        if (cNode != null) {
                            StructuredSelection ss = new StructuredSelection((Object)cNode);
                            this.fTreeViewer.setSelection((ISelection)ss, true);
                            this.fTreeViewer.expandToLevel((Object)ss, 1);
                        }
                    }
                    catch (RuntimeException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                this.update();
            }
        }
    }

    public INode getEndNode(INode node) {
        INode n = node.getLastChild();
        if (n == null) {
            return node;
        }
        return this.getEndNode(n);
    }

    public CurrentSql getCurrentSql() {
        return this.currentSql;
    }

    public SqlEditor2 getEditor() {
        return this.editor;
    }

    static /* synthetic */ TreeViewer access$1(SQLOutinePage sQLOutinePage) {
        return sQLOutinePage.getTreeViewer();
    }

    class ExpandAllAction
    extends Action {
        public ExpandAllAction() {
            super("Expand All", 1);
            this.setImageDescriptor(DbPlugin.getDefault().getImageDescriptor("expandAll.gif"));
        }

        public void run() {
            SQLOutinePage.this.fTreeViewer.expandAll();
        }
    }

    class CollapseAllAction
    extends Action {
        public CollapseAllAction() {
            super("Collapse All", 1);
            this.setImageDescriptor(DbPlugin.getDefault().getImageDescriptor("collapseAll.gif"));
        }

        public void run() {
            SQLOutinePage.this.fTreeViewer.collapseAll();
        }
    }

    class ChangeModeAction
    extends Action {
        public ChangeModeAction() {
            super("ASTMode", 2);
        }

        public void run() {
            SQLOutinePage.this.isASTMode = this.isChecked();
            SQLOutinePage.this.fTreeViewer.refresh();
        }
    }

    class SqlInput {
        INode documentElement;

        SqlInput() {
        }
    }

    class DoubleClickListener
    implements IDoubleClickListener {
        int offset = -1;
        int length = -1;

        DoubleClickListener() {
        }

        private void calc(ASTColumn node) {
            this.offset = node.getOffset();
            this.length = node.getLength();
            if (node.hasAlias()) {
                this.length = node.getAliasOffset() + node.getAliasLength() - this.offset;
            }
        }

        private void calc(ASTParentheses node) {
            this.offset = node.getOffset();
            this.length = node.getEndOffset() + 1 - this.offset;
            if (node.hasAlias()) {
                this.length = node.getAliasOffset() + node.getAliasLength() - this.offset;
            }
        }

        private void calc(ASTSelectStatement node) {
            ASTAlias as;
            INode last = SQLOutinePage.this.getEndNode((INode)node);
            this.offset = node.getOffset();
            this.length = last.getOffset() + last.getLength() - this.offset;
            if (last instanceof ASTAlias && (as = (ASTAlias)last).hasAlias()) {
                this.length = as.getAliasOffset() + as.getAliasLength() - this.offset;
            }
        }

        private void calc(ASTFunction node) {
            if (node.getChildrenSize() == 1 && node.getChild(0) instanceof ASTParentheses) {
                ASTParentheses cfr_ignored_0 = (ASTParentheses)node.getChild(0);
                this.calc((ASTParentheses)node.getChild(0));
                this.offset = node.getOffset();
                this.length += node.getLength();
                if (node.hasAlias()) {
                    this.length = node.getAliasOffset() + node.getAliasLength() - this.offset;
                }
            }
        }

        public void doubleClick(DoubleClickEvent event) {
            try {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                Object element = sel.getFirstElement();
                if (element instanceof ASTColumn) {
                    this.calc((ASTColumn)element);
                } else if (element instanceof ASTParentheses) {
                    this.calc((ASTParentheses)element);
                } else if (element instanceof ASTSelectStatement) {
                    this.calc((ASTSelectStatement)element);
                } else if (element instanceof ASTFunction) {
                    this.calc((ASTFunction)element);
                } else if (element instanceof Node) {
                    Node node = (Node)element;
                    this.offset = node.getOffset();
                    this.length = node.getLength();
                }
                if (this.offset >= 0) {
                    SQLOutinePage.this.revealRange(this.offset, this.length);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class TreeLabelProvider
    extends LabelProvider {
        ImageCacher ic = ImageCacher.getInstance();

        TreeLabelProvider() {
        }

        public String getText(Object obj) {
            if (obj instanceof Node) {
                if (SQLOutinePage.this.isASTMode) {
                    return ((Node)obj).toString();
                }
                if (obj instanceof ASTFunction) {
                    ASTVisitorToString v = new ASTVisitorToString();
                    ASTFunction f = (ASTFunction)obj;
                    f.accept((IVisitor)v, null);
                    return v.toString();
                }
                return ((Node)obj).getName();
            }
            return obj.toString();
        }

        public Image getImage(Object obj) {
            if (obj instanceof ASTTable) {
                return this.ic.getImage("table.gif");
            }
            if (obj instanceof ASTValue) {
                return this.ic.getImage("sql.gif");
            }
            if (obj instanceof ASTColumn) {
                return this.ic.getImage("column.gif");
            }
            return this.ic.getImage("sql.gif");
        }
    }

    class TreeContentProvider
    implements ITreeContentProvider {
        TreeContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(SQLOutinePage.this.fSqlInput.documentElement);
        }

        public Object getParent(Object element) {
            if (element instanceof Node) {
                return ((Node)element).getParent();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            Node node;
            List list;
            ArrayList result = new ArrayList();
            if (parentElement != null && parentElement instanceof Node && (list = (node = (Node)parentElement).getChildren()) != null) {
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    Object obj = iter.next();
                    if (obj instanceof ASTComma || obj instanceof ASTInnerAlias) continue;
                    result.add(obj);
                }
            }
            return result.toArray(new Node[0]);
        }

        public boolean hasChildren(Object element) {
            if (element instanceof Node) {
                return ((Node)element).getChildrenSize() > 0;
            }
            return false;
        }
    }

    class ParseCancel
    extends ParserException {
        public ParseCancel(String message) {
            super(message, null, 0, 0);
        }
    }

    class SqlParserWithProgressMonitor
    extends SqlParser
    implements ISqlParser {
        IProgressMonitor monitor;

        public SqlParserWithProgressMonitor(IProgressMonitor monitor, String sql, SqlFormatRule rule) {
            super(sql, rule);
            this.monitor = monitor;
        }

        protected int nextToken() {
            if (this.monitor.isCanceled()) {
                throw new ParseCancel("SQL Parse cancel");
            }
            this.monitor.worked(1);
            return super.nextToken();
        }
    }

    class UpdateOutlineJob
    extends AbstractJob {
        CurrentSql currentSql;

        public UpdateOutlineJob(CurrentSql currentSql) {
            super("Updating SQL Outline");
            this.currentSql = currentSql;
        }

        /*
         * Exception decompiling
         */
        protected IStatus run(IProgressMonitor monitor) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [11 : 297->300)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        static /* synthetic */ SQLOutinePage access$0(UpdateOutlineJob updateOutlineJob) {
            return updateOutlineJob.SQLOutinePage.this;
        }
    }
}

