/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.views.internal;

import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import zigen.plugin.db.DbPluginFormatRule;
import zigen.plugin.db.ui.views.internal.ColorManager;
import zigen.plugin.db.ui.views.internal.ISQLTokenScanner;

public class SQLKeywordScanner
extends RuleBasedScanner
implements ISQLTokenScanner {
    private ColorManager colorManager;
    protected DbPluginFormatRule rule;

    public SQLKeywordScanner(ColorManager colorManager) {
        this.colorManager = colorManager;
        this.rule = DbPluginFormatRule.getInstance();
        this.initialize(false);
    }

    public void initialize() {
        this.initialize(true);
    }

    public void initialize(boolean marge) {
        if (marge) {
            this.rule.margeTemplate();
        }
        this.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor("SQLEditorPreferencePage.ColorDefailt"))));
        IRule[] rules = new IRule[2];
        Token other = new Token((Object)new TextAttribute(this.colorManager.getColor("SQLEditorPreferencePage.ColorDefailt")));
        Token keyword = new Token((Object)new TextAttribute(this.colorManager.getColor("SQLEditorPreferencePage.ColorKeyword"), null, 1));
        Token function = new Token((Object)new TextAttribute(this.colorManager.getColor("SQLEditorPreferencePage.ColorFunction"), null, 1));
        WordRule wordRule = new WordRule((IWordDetector)new WordDetector(), (IToken)other);
        String[] keywords = this.rule.getKeywordNames();
        int i = 0;
        while (i < keywords.length) {
            String key = keywords[i];
            wordRule.addWord(key, (IToken)keyword);
            wordRule.addWord(key.toLowerCase(), (IToken)keyword);
            ++i;
        }
        String[] functions = this.rule.getFunctionNames();
        int i2 = 0;
        while (i2 < functions.length) {
            String name = functions[i2];
            wordRule.addWord(name, (IToken)function);
            wordRule.addWord(name.toLowerCase(), (IToken)function);
            ++i2;
        }
        rules[0] = wordRule;
        rules[1] = new WhitespaceRule((IWhitespaceDetector)new WhitespaceDetector());
        this.setRules(rules);
    }

    static class WordDetector
    implements IWordDetector {
        WordDetector() {
        }

        public boolean isWordPart(char c) {
            return Character.isJavaIdentifierPart(c);
        }

        public boolean isWordStart(char c) {
            return Character.isJavaIdentifierStart(c);
        }
    }

    static class WhitespaceDetector
    implements IWhitespaceDetector {
        WhitespaceDetector() {
        }

        public boolean isWhitespace(char character) {
            return Character.isWhitespace(character);
        }
    }
}

