/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.views.internal;

import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.ImageCacher;
import zigen.plugin.db.PluginSettingsManager;
import zigen.plugin.db.core.ColumnLayout;
import zigen.plugin.db.core.FolderInfo;
import zigen.plugin.db.ui.internal.DataBase;
import zigen.plugin.db.ui.views.TreeView;
import zigen.plugin.db.ui.views.internal.FilterComposite;
import zigen.plugin.db.ui.views.internal.Messages;

public class ElementFilterDialog
extends Dialog {
    PluginSettingsManager pluginMgr = DbPlugin.getDefault().getPluginSettingsManager();
    private TreeView treeView;
    FilterComposite filterComposite;
    FolderInfo[] settingFolders = null;
    FolderInfo[] filterFolders = null;
    CheckboxTableViewer fTableViewer;
    Map settingFolderMap = new TreeMap();
    private static final int BUTTON_ID_SELECTALL = -100;
    private static final int BUTTON_ID_REMOVEALL = -101;

    public ElementFilterDialog(Shell parent, TreeView treeView) {
        super(parent);
        Dialog.setDefaultImage((Image)ImageCacher.getInstance().getImage("db.gif"));
        this.setShellStyle(this.getShellStyle() | 0x400 | 0x10);
        this.treeView = treeView;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("ElementFilterDialog.3"));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, -100, Messages.getString("ElementFilterDialog.4"), false);
        this.createButton(parent, -101, Messages.getString("ElementFilterDialog.5"), false);
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public boolean close() {
        return super.close();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1) {
            this.setReturnCode(buttonId);
            this.close();
        } else if (buttonId == 0) {
            this.pluginMgr.setValue("KEY_ELEM_FILTER_VISIBLE", new Boolean(this.filterComposite.visibleCheck.getSelection()));
            this.pluginMgr.setValue("KEY_ELEM_FILTER_PATTERN", this.filterComposite.filterText.getText());
            this.pluginMgr.setValue("KEY_ELEM_FILTER_REGULAREXP", new Boolean(this.filterComposite.regularExpressions.getSelection()));
            this.pluginMgr.setValue("KEY_ELEM_FILTER_CASESENSITIVE", new Boolean(this.filterComposite.caseSensitive.getSelection()));
            this.pluginMgr.setValue("KEY_ELEM_FILTER_FOLDER_LIST", this.filterFolders);
        } else if (buttonId == -100) {
            int i = 0;
            while (i < this.fTableViewer.getTable().getItemCount()) {
                FolderInfo info = (FolderInfo)this.fTableViewer.getElementAt(i);
                info.setChecked(true);
                this.fTableViewer.setChecked((Object)info, true);
                ++i;
            }
        } else if (buttonId == -101) {
            int i = 0;
            while (i < this.fTableViewer.getTable().getItemCount()) {
                FolderInfo info = (FolderInfo)this.fTableViewer.getElementAt(i);
                info.setChecked(false);
                this.fTableViewer.setChecked((Object)info, false);
                ++i;
            }
        }
        super.buttonPressed(buttonId);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.filterComposite = new FilterComposite(composite, Messages.getString("ElementFilterDialog.0"));
        this.filterComposite.visibleCheck.setSelection(this.pluginMgr.getValueBoolean("KEY_ELEM_FILTER_VISIBLE"));
        this.filterComposite.filterText.setText(this.pluginMgr.getValueString("KEY_ELEM_FILTER_PATTERN"));
        this.filterComposite.regularExpressions.setSelection(this.pluginMgr.getValueBoolean("KEY_ELEM_FILTER_REGULAREXP"));
        this.filterComposite.caseSensitive.setSelection(this.pluginMgr.getValueBoolean("KEY_ELEM_FILTER_CASESENSITIVE"));
        this.filterComposite.visibleCheck.notifyListeners(13, null);
        this.filterComposite.regularExpressions.notifyListeners(13, null);
        this.settingFolders = (FolderInfo[])this.pluginMgr.getValue("KEY_ELEM_FILTER_FOLDER_LIST");
        if (this.settingFolders != null) {
            int i = 0;
            while (i < this.settingFolders.length) {
                FolderInfo info = this.settingFolders[i];
                this.settingFolderMap.put(info.getName(), info);
                ++i;
            }
        }
        this.createFolderArea(composite);
        return composite;
    }

    protected void createFolderArea(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText(Messages.getString("ElementFilterDialog.1"));
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new GridLayout(1, false));
        Label labe2 = new Label((Composite)group, 0);
        labe2.setText(Messages.getString("ElementFilterDialog.2"));
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        labe2.setLayoutData((Object)data);
        Composite tableComposite = new Composite((Composite)group, 0);
        data = new GridData(1808);
        data.widthHint = 200;
        data.heightHint = 120;
        tableComposite.setLayoutData((Object)data);
        ColumnLayout columnLayout = new ColumnLayout();
        tableComposite.setLayout((Layout)columnLayout);
        Table table = new Table(tableComposite, 2850);
        table.setHeaderVisible(false);
        table.setLinesVisible(false);
        GC gc = new GC((Drawable)this.getShell());
        gc.setFont(JFaceResources.getDialogFont());
        TableColumn column1 = new TableColumn(table, 0);
        column1.setText("");
        int minWidth = this.computeMinimumColumnWidth(gc, "");
        columnLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, minWidth, true));
        gc.dispose();
        this.fTableViewer = new CheckboxTableViewer(table);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new FolderLabelProvider());
        this.fTableViewer.setContentProvider((IContentProvider)new FolderContentProvider());
        this.filterFolders = this.loadFolders();
        this.fTableViewer.setInput((Object)this.filterFolders);
        if (this.filterFolders != null) {
            int i = 0;
            while (i < this.filterFolders.length) {
                FolderInfo info = this.filterFolders[i];
                this.fTableViewer.setChecked((Object)info, info.isChecked());
                ++i;
            }
        }
        this.fTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                FolderInfo info = (FolderInfo)event.getElement();
                info.setChecked(event.getChecked());
            }
        });
    }

    protected int computeMinimumColumnWidth(GC gc, String string) {
        return gc.stringExtent((String)string).x + 10;
    }

    private FolderInfo[] loadFolders() {
        FolderInfo[] folders = null;
        boolean isSetting = !this.settingFolderMap.isEmpty();
        try {
            DataBase[] dbs = this.treeView.getContentProvider().getDataBases();
            ArrayList<String> newList = new ArrayList<String>();
            newList.add("TABLE");
            newList.add("VIEW");
            int i = 0;
            while (i < dbs.length) {
                DataBase db = dbs[i];
                if (db.isConnected()) {
                    String[] types = db.getTableType();
                    int j = 0;
                    while (j < types.length) {
                        String type = types[j];
                        if (!newList.contains(type)) {
                            newList.add(type);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            String[] newNames = newList.toArray(new String[0]);
            if (!isSetting) {
                folders = new FolderInfo[newList.size()];
                int i2 = 0;
                while (i2 < newList.size()) {
                    folders[i2] = new FolderInfo(newNames[i2], false);
                    ++i2;
                }
            } else {
                folders = new FolderInfo[newNames.length];
                int i3 = 0;
                while (i3 < newNames.length) {
                    folders[i3] = this.settingFolderMap.containsKey(newNames[i3]) ? (FolderInfo)this.settingFolderMap.get(newNames[i3]) : new FolderInfo(newNames[i3], false);
                    ++i3;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return folders;
    }

    public FolderInfo[] getFilterFolders() {
        return this.filterFolders;
    }

    class FolderLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        FolderLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            FolderInfo data = (FolderInfo)element;
            switch (columnIndex) {
                case 0: {
                    return data.getName();
                }
            }
            return "";
        }
    }

    class FolderContentProvider
    implements IStructuredContentProvider {
        FolderContentProvider() {
        }

        public Object[] getElements(Object input) {
            if (input instanceof FolderInfo[]) {
                return (FolderInfo[])input;
            }
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }
}

