/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.views.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import zigen.plugin.db.DbPlugin;

public class ColorManager {
    protected Map fColorTable = new HashMap();
    protected IPreferenceStore store = DbPlugin.getDefault().getPreferenceStore();

    public Color getColor(RGB rgb) {
        Color color = (Color)this.fColorTable.get(rgb);
        if (color == null) {
            color = new Color((Device)Display.getCurrent(), rgb);
            this.fColorTable.put(rgb, color);
        }
        return color;
    }

    public Color getColor(String prefKey) {
        String colorName = this.store.getString(prefKey);
        RGB rgb = StringConverter.asRGB((String)colorName);
        return this.getColor(rgb);
    }

    public void dispose() {
        Iterator e = this.fColorTable.values().iterator();
        while (e.hasNext()) {
            ((Color)e.next()).dispose();
        }
    }
}

