/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.views;

import java.util.TreeMap;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.SchemaInfo;
import zigen.plugin.db.ui.internal.Schema;

public class TreeViewSchemaFilter
extends ViewerFilter {
    TreeMap settingSchemaMap = new TreeMap();

    public TreeViewSchemaFilter(SchemaInfo[] settingSchemas) {
        if (settingSchemas != null) {
            int i = 0;
            while (i < settingSchemas.length) {
                SchemaInfo info = settingSchemas[i];
                String key = String.valueOf(info.getConfig().getDbName()) + "@" + info.getName();
                this.settingSchemaMap.put(key.toLowerCase(), info);
                ++i;
            }
        }
    }

    public boolean select(Viewer viewer, Object parent, Object element) {
        if (!this.settingSchemaMap.isEmpty()) {
            if (element instanceof Schema) {
                Schema _schema = (Schema)element;
                IDBConfig config = _schema.getDbConfig();
                String key = (String.valueOf(config.getDbName()) + "@" + _schema.getName()).toLowerCase();
                if (this.settingSchemaMap.containsKey(key)) {
                    SchemaInfo si = (SchemaInfo)this.settingSchemaMap.get(key);
                    return si.isChecked();
                }
                return true;
            }
            return true;
        }
        return true;
    }
}

