/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.views;

import java.io.File;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.ui.internal.TreeLeaf;
import zigen.plugin.db.ui.util.FileUtil;
import zigen.plugin.db.ui.views.Messages;

public class DropTreeLeafAdapter
extends DropTargetAdapter {
    SourceViewer viewer;

    public DropTreeLeafAdapter(SourceViewer viewer) {
        this.viewer = viewer;
    }

    public void dragEnter(DropTargetEvent e) {
        if (e.detail == 16) {
            e.detail = 1;
        }
    }

    public void dragOperationChanged(DropTargetEvent e) {
        if (e.detail == 16) {
            e.detail = 1;
        }
    }

    public void drop(DropTargetEvent e) {
        if (e.data == null) {
            e.detail = 0;
            return;
        }
        if (e.data instanceof TreeLeaf[]) {
            TreeLeaf[] leafs = (TreeLeaf[])e.data;
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < leafs.length) {
                TreeLeaf leaf = leafs[i];
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(leaf.getName());
                ++i;
            }
            String str = sb.toString();
            int offset = this.viewer.getTextWidget().getCaretOffset();
            this.viewer.getTextWidget().insert(str);
            this.viewer.getTextWidget().setCaretOffset(offset + str.length());
            this.viewer.activatePlugins();
            this.viewer.getControl().forceFocus();
            this.viewer.getTextWidget().setFocus();
        } else if (e.data instanceof String[]) {
            String[] strs = (String[])e.data;
            if (strs.length == 1) {
                File file = new File(strs[0]);
                if (file.exists() && FileUtil.isSqlFile(file)) {
                    String content = FileUtil.getContents(file);
                    String pre = this.viewer.getDocument().get().trim();
                    if ("".equals(pre)) {
                        this.viewer.getDocument().set(content);
                        this.viewer.activatePlugins();
                        this.viewer.getControl().forceFocus();
                        this.viewer.getTextWidget().setFocus();
                    } else {
                        String msg = Messages.getString("DropTreeLeafAdapter.2");
                        if (DbPlugin.getDefault().confirmDialog(msg)) {
                            this.viewer.getDocument().set(content);
                            this.viewer.activatePlugins();
                            this.viewer.getControl().forceFocus();
                            this.viewer.getTextWidget().setFocus();
                        }
                    }
                }
            } else {
                DbPlugin.getDefault().showWarningMessage(Messages.getString("DropTreeLeafAdapter.3"));
            }
        }
    }
}

