/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.jobs;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.DbPluginConstant;
import zigen.plugin.db.core.TimeWatcher;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.core.rule.DefaultSQLCreatorFactory;
import zigen.plugin.db.core.rule.ISQLCreatorFactory;
import zigen.plugin.db.ui.actions.ConfirmConnectDBAction;
import zigen.plugin.db.ui.editors.QueryViewEditor2;
import zigen.plugin.db.ui.editors.QueryViewEditorInput;
import zigen.plugin.db.ui.jobs.AbstractJob;
import zigen.plugin.db.ui.jobs.Messages;
import zigen.plugin.db.ui.jobs.TotalRecordCountSearchThread;

public class RecordCountForQueryJob
extends AbstractJob {
    int timeoutSec = 5;
    private Transaction trans;
    private String sqlString;
    String secondarlyId;
    int dispCount;

    public RecordCountForQueryJob(Transaction trans, String sqlString, String secondarlyId, int dispCount) {
        super(Messages.getString("RecordCountForQueryJob.0"));
        this.trans = trans;
        this.sqlString = sqlString;
        this.secondarlyId = secondarlyId;
        this.dispCount = dispCount;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            if (!this.trans.isConneting()) {
                Display.getDefault().syncExec((Runnable)new ConfirmConnectDBAction(this.trans));
                if (!this.trans.isConneting()) {
                    this.showWarningMessage(DbPluginConstant.MSG_NO_CONNECTED_DB);
                    return Status.CANCEL_STATUS;
                }
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            TimeWatcher tw = new TimeWatcher();
            tw.start();
            int timeout = this.store.getInt("PreferencePage.QueryTimeoutForCount");
            ISQLCreatorFactory factory = DefaultSQLCreatorFactory.getFactory(this.trans.getConfig(), null);
            String q = factory.createCountForQuery(this.sqlString);
            System.out.println(q);
            TotalRecordCountSearchThread t = new TotalRecordCountSearchThread(this.trans, q, timeout);
            Thread th = new Thread(t);
            th.start();
            if (timeout > 0) {
                th.join(timeout * 1000);
            } else {
                th.join();
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            if (t.isComplete) {
                this.showResults(new SetTotalCountAction(t.count));
            } else {
                this.showResults(new SetTotalCountAction(-1L));
            }
            tw.stop();
        }
        catch (Exception e) {
            DbPlugin.log(e);
            this.showResults(new SetTotalCountAction(-1L));
        }
        return Status.OK_STATUS;
    }

    protected class SetTotalCountAction
    implements Runnable {
        long count;

        public SetTotalCountAction(long count) {
            this.count = count;
        }

        public void run() {
            try {
                IWorkbenchPage page = DbPlugin.getDefault().getPage();
                QueryViewEditorInput input = new QueryViewEditorInput(RecordCountForQueryJob.this.trans.getConfig(), RecordCountForQueryJob.this.sqlString, RecordCountForQueryJob.this.secondarlyId);
                IEditorPart editor = IDE.openEditor((IWorkbenchPage)page, (IEditorInput)input, (String)"zigen.plugin.db.ui.editors.QueryViewEditor2", (boolean)false);
                if (editor instanceof QueryViewEditor2) {
                    QueryViewEditor2 tEditor = (QueryViewEditor2)editor;
                    tEditor.setTotalCount(RecordCountForQueryJob.this.dispCount, this.count);
                }
            }
            catch (Exception e) {
                DbPlugin.log(e);
            }
        }
    }
}

