/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.jobs;

import java.sql.Connection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.TreeViewer;
import zigen.plugin.db.core.ConnectionManager;
import zigen.plugin.db.core.DBType;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.TimeWatcher;
import zigen.plugin.db.ui.editors.exceptions.NotFoundSynonymInfoException;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.jobs.AbstractLoadColumnJob;
import zigen.plugin.db.ui.jobs.Messages;
import zigen.plugin.db.ui.jobs.RefreshTreeNodeAction;

public class LoadColumnsJob
extends AbstractLoadColumnJob {
    TreeViewer viewer;
    ITable[] tables;
    IDBConfig config;
    int total = 0;
    StringBuffer err = new StringBuffer();

    public LoadColumnsJob(TreeViewer viewer, IDBConfig config, ITable[] tables) {
        super("Loading All column information...");
        this.viewer = viewer;
        this.tables = tables;
        this.config = config;
        if (tables != null) {
            this.total = tables.length * 6;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IStatus run(IProgressMonitor monitor) {
        TimeWatcher tw = new TimeWatcher();
        tw.start();
        Connection con = null;
        try {
            try {
                con = ConnectionManager.getConnection(this.config);
                monitor.beginTask("Refresh Column...", this.total);
                int i = 0;
                while (i < this.tables.length) {
                    ITable table = this.tables[i];
                    if (!table.isExpanded()) {
                        if (DBType.getType(this.config) == 1 && this.config.getDataBaseProductMajorVersion() == 10) {
                            if (!table.getName().startsWith("BIN$")) {
                                this.loadTable(monitor, con, table, this.total);
                            } else {
                                monitor.worked(1);
                            }
                        } else {
                            this.loadTable(monitor, con, table, this.total);
                        }
                    }
                    ++i;
                }
            }
            catch (InterruptedException interruptedException) {
                IStatus iStatus = Status.CANCEL_STATUS;
                Object var6_9 = null;
                ConnectionManager.closeConnection(con);
                monitor.done();
                return iStatus;
            }
            catch (Exception e) {
                this.showErrorMessage(Messages.getString("RefreshColumnJob.2"), e);
                IStatus iStatus = Status.CANCEL_STATUS;
                Object var6_10 = null;
                ConnectionManager.closeConnection(con);
                monitor.done();
                return iStatus;
            }
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            ConnectionManager.closeConnection(con);
            monitor.done();
            throw throwable;
        }
        {
            Object var6_12 = null;
        }
        ConnectionManager.closeConnection(con);
        monitor.done();
        tw.stop();
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTable(IProgressMonitor monitor, Connection con, ITable table, int total) throws Exception {
        try {
            monitor.subTask(String.valueOf(Messages.getString("LoadColumnsJob.3")) + table.getSqlTableName());
            ITable iTable = table;
            synchronized (iTable) {
                con = ConnectionManager.getConnection(this.config);
                if (!this.loadColumnInfo(monitor, con, table)) {
                    table.setExpanded(false);
                    throw new InterruptedException();
                }
                table.setExpanded(true);
                this.showResults(new RefreshTreeNodeAction(this.viewer, table));
            }
        }
        catch (NotFoundSynonymInfoException e) {
            table.setEnabled(false);
            table.removeChildAll();
            this.showResults(new RefreshTreeNodeAction(this.viewer, table));
            throw e;
        }
        catch (Exception e) {
            table.setExpanded(false);
            throw e;
        }
    }
}

