/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.jobs;

import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.DbPluginConstant;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.SchemaSearcher;
import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.core.TableInfo;
import zigen.plugin.db.core.TableSearcher;
import zigen.plugin.db.core.TableTypeSearcher;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.DataBase;
import zigen.plugin.db.ui.internal.Folder;
import zigen.plugin.db.ui.internal.Schema;
import zigen.plugin.db.ui.internal.Table;
import zigen.plugin.db.ui.internal.TreeNode;
import zigen.plugin.db.ui.internal.View;
import zigen.plugin.db.ui.jobs.AbstractJob;
import zigen.plugin.db.ui.jobs.ChangeTransactionIsolationLevelAction;
import zigen.plugin.db.ui.jobs.Messages;
import zigen.plugin.db.ui.jobs.RefreshTreeNodeAction;
import zigen.plugin.db.ui.jobs.TableTypeSearchJob;
import zigen.plugin.db.ui.jobs.TestConnectThread;

public class ConnectDBJob
extends AbstractJob {
    public static final String VisibleFolderPattern = "^TABLE|^VIEW|^SYNONYM|^ALIAS";
    private TreeViewer viewer;
    private DataBase db;

    public ConnectDBJob(TreeViewer viewer, DataBase db) {
        super(Messages.getString("ConnectDBJob.1"));
        this.viewer = viewer;
        this.db = db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        try {
            TreeViewer treeViewer = this.viewer;
            synchronized (treeViewer) {
                monitor.beginTask("Connect DataBase...", 3);
                IDBConfig config = this.db.getDbConfig();
                int timeout = this.store.getInt("PreferencePage.ConnectTimeout");
                TestConnectThread t = new TestConnectThread(config, timeout, true);
                Thread th = new Thread(t);
                th.setPriority(1);
                th.start();
                if (timeout > 0) {
                    th.join(timeout * 1000);
                } else {
                    th.join();
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                monitor.worked(1);
                if (!t.isSuccess) {
                    this.db.setConnected(false);
                    this.db.setExpanded(false);
                    if (t.getThrowable() == null) {
                        SQLException se = new SQLException("Connection timeout occurred.");
                        t.setThrowable(se);
                    }
                    this.showErrorMessage(t.getMessage(), t.getThrowable());
                    return Status.CANCEL_STATUS;
                }
                Connection con = Transaction.getInstance(config).getConnection();
                Display.getDefault().syncExec((Runnable)new ChangeTransactionIsolationLevelAction(config));
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                this.db.removeChildAll();
                this.showResults(new RefreshTreeNodeAction(this.viewer, this.db));
                this.db.setSchemaSupport(SchemaSearcher.isSupport(con));
                this.db.setDefaultSchema(config.getSchema());
                String[] tableTypes = TableTypeSearcher.execute(con);
                monitor.worked(1);
                this.db.setTableType(tableTypes);
                if (this.db.isSchemaSupport()) {
                    String[] schemas = SchemaSearcher.execute(con);
                    this.addSchemas(this.db, schemas);
                } else {
                    int i = 0;
                    while (i < tableTypes.length) {
                        String[] type = new String[]{tableTypes[i]};
                        if (tableTypes[i].toUpperCase().matches(VisibleFolderPattern)) {
                            this.addTables(this.db, tableTypes[i], TableSearcher.execute(con, null, type));
                        }
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        ++i;
                    }
                }
                this.db.setConnected(true);
                this.showResults(new RefreshTreeNodeAction(this.viewer, this.db, 1));
                monitor.worked(1);
            }
        }
        catch (Exception e) {
            this.db.setConnected(false);
            this.db.setExpanded(false);
            this.showErrorMessage(Messages.getString("ConnectDBJob.2"), e);
        }
        return Status.OK_STATUS;
    }

    private void addSchemas(DataBase db, String[] schemas) throws Exception {
        boolean onlyDefaultSchema = false;
        int i = 0;
        while (i < schemas.length) {
            Schema schema = new Schema(schemas[i]);
            if (!onlyDefaultSchema) {
                db.addChild(schema);
            } else if (db.getDefaultSchema().toUpperCase().equals(schemas[i].toUpperCase())) {
                db.addChild(schema);
            }
            if (db.getDefaultSchema().toUpperCase().equals(schemas[i].toUpperCase())) {
                if (this.viewer instanceof TreeViewer) {
                    TableTypeSearchJob job = new TableTypeSearchJob(this.viewer, schema);
                    job.setPriority(20);
                    job.schedule();
                    try {
                        job.join();
                    }
                    catch (InterruptedException e) {
                        DbPlugin.log(e);
                    }
                    schema.setExpanded(true);
                    this.showResults(new RefreshTreeNodeAction(this.viewer, schema, 1));
                }
            } else {
                schema.addChild(new Folder(DbPluginConstant.TREE_LEAF_LOADING));
            }
            ++i;
        }
    }

    private void addTables(TreeNode parent, String label, TableInfo[] tables) {
        Folder folder = new Folder(label);
        int i = 0;
        while (i < tables.length) {
            TableInfo tableinfo = tables[i];
            Table table = "VIEW".equals(label) ? new View(tableinfo.getName(), tableinfo.getComment()) : new Table(tableinfo.getName(), tableinfo.getComment());
            folder.addChild(table);
            TableColumn tColumn = new TableColumn();
            tColumn.setColumnName(DbPluginConstant.TREE_LEAF_LOADING);
            table.addChild(new Column(tColumn));
            ++i;
        }
        parent.addChild(folder);
    }
}

