/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.jobs;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.ui.jobs.Messages;
import zigen.plugin.db.ui.views.TreeView;

public class ChangeTransactionIsolationLevelAction
implements Runnable {
    private IDBConfig config;

    public ChangeTransactionIsolationLevelAction(IDBConfig config) {
        this.config = config;
    }

    public void setMessageForTreeView(String message) {
        TreeView view = (TreeView)DbPlugin.findView("zigen.plugin.db.ui.views.TreeView");
        if (view != null) {
            view.setStatusMessage(this.config, message);
        }
    }

    public void run() {
        try {
            Transaction trans = Transaction.getInstance(this.config);
            Connection con = trans.getConnection();
            DatabaseMetaData metaData = con.getMetaData();
            switch (con.getTransactionIsolation()) {
                case 2: {
                    break;
                }
                case 0: {
                    DbPlugin.getDefault().showWarningMessage(Messages.getString("ChangeTransactionIsolationLevelAction.0"));
                    break;
                }
                case 1: {
                    if (metaData.supportsTransactionIsolationLevel(2)) {
                        con.setTransactionIsolation(2);
                        StringBuffer sb = new StringBuffer();
                        sb.append(Messages.getString("ChangeTransactionIsolationLevelAction.1"));
                        sb.append(Messages.getString("ChangeTransactionIsolationLevelAction.2"));
                        sb.append(Messages.getString("ChangeTransactionIsolationLevelAction.3"));
                        this.setMessageForTreeView(sb.toString());
                        break;
                    }
                    StringBuffer sb = new StringBuffer();
                    sb.append(Messages.getString("ChangeTransactionIsolationLevelAction.4"));
                    sb.append(Messages.getString("ChangeTransactionIsolationLevelAction.5"));
                    DbPlugin.getDefault().showWarningMessage(sb.toString());
                    break;
                }
                case 4: {
                    if (metaData.supportsTransactionIsolationLevel(2)) {
                        con.setTransactionIsolation(2);
                        StringBuffer sb = new StringBuffer();
                        sb.append(Messages.getString("ChangeTransactionIsolationLevelAction.6"));
                        sb.append(Messages.getString("ChangeTransactionIsolationLevelAction.7"));
                        sb.append(Messages.getString("ChangeTransactionIsolationLevelAction.8"));
                        this.setMessageForTreeView(sb.toString());
                        break;
                    }
                    StringBuffer sb = new StringBuffer();
                    sb.append(Messages.getString("ChangeTransactionIsolationLevelAction.9"));
                    sb.append(Messages.getString("ChangeTransactionIsolationLevelAction.10"));
                    DbPlugin.getDefault().showWarningMessage(sb.toString());
                    break;
                }
                case 8: {
                    if (metaData.supportsTransactionIsolationLevel(2)) {
                        con.setTransactionIsolation(2);
                        StringBuffer sb = new StringBuffer();
                        sb.append(Messages.getString("ChangeTransactionIsolationLevelAction.11"));
                        sb.append(Messages.getString("ChangeTransactionIsolationLevelAction.12"));
                        sb.append(Messages.getString("ChangeTransactionIsolationLevelAction.13"));
                        this.setMessageForTreeView(sb.toString());
                        break;
                    }
                    StringBuffer sb = new StringBuffer();
                    sb.append(Messages.getString("ChangeTransactionIsolationLevelAction.14"));
                    sb.append(Messages.getString("ChangeTransactionIsolationLevelAction.15"));
                    DbPlugin.getDefault().showWarningMessage(sb.toString());
                    break;
                }
                default: {
                    DbPlugin.getDefault().showWarningMessage(Messages.getString("ChangeTransactionIsolationLevelAction.16"));
                    break;
                }
            }
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }
}

