/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.jobs;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import zigen.plugin.db.DbPluginConstant;
import zigen.plugin.db.core.DBType;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.SchemaSearcher;
import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.core.TableConstraintColumn;
import zigen.plugin.db.core.TableFKColumn;
import zigen.plugin.db.core.TableIDXColumn;
import zigen.plugin.db.core.TablePKColumn;
import zigen.plugin.db.core.TimeWatcher;
import zigen.plugin.db.core.rule.DefaultColumnSearcherFactory;
import zigen.plugin.db.core.rule.DefaultConstraintSearcherFactory;
import zigen.plugin.db.core.rule.IColumnSearcherFactory;
import zigen.plugin.db.core.rule.IConstraintSearcherFactory;
import zigen.plugin.db.ext.oracle.internal.OracleIndexSearcher;
import zigen.plugin.db.ext.oracle.internal.OracleSynonymInfoSearcher;
import zigen.plugin.db.ext.oracle.internal.SynonymInfo;
import zigen.plugin.db.ui.internal.Bookmark;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.internal.OracleColumn;
import zigen.plugin.db.ui.internal.Synonym;
import zigen.plugin.db.ui.internal.TreeLeaf;
import zigen.plugin.db.ui.jobs.AbstractJob;
import zigen.plugin.db.ui.jobs.Messages;

public abstract class AbstractLoadColumnJob
extends AbstractJob {
    public AbstractLoadColumnJob(String msg) {
        super(msg);
    }

    protected boolean loadColumnInfo(IProgressMonitor monitor, Connection con, ITable table) throws Exception {
        IConstraintSearcherFactory constraintFactory;
        IColumnSearcherFactory factory;
        TimeWatcher tw = new TimeWatcher();
        tw.start();
        TableColumn[] columns = null;
        TablePKColumn[] pks = null;
        TableFKColumn[] fks = null;
        TableConstraintColumn[] cons = null;
        TableIDXColumn[] uidxs = null;
        TableIDXColumn[] nonuidxs = null;
        IDBConfig config = table.getDbConfig();
        config.isConvertUnicode();
        String schemaName = table.getSchemaName();
        String tableName = table.getName();
        if (monitor.isCanceled()) {
            return false;
        }
        switch (DBType.getType(con.getMetaData())) {
            case 1: {
                Bookmark bm;
                if (table instanceof Synonym) {
                    Synonym synonym = (Synonym)table;
                    schemaName = synonym.getTable_owner();
                    tableName = synonym.getTable_name();
                    break;
                }
                if (!(table instanceof Bookmark) || !(bm = (Bookmark)table).isSynonym()) break;
                SynonymInfo info = OracleSynonymInfoSearcher.execute(con, bm.getSchemaName(), bm.getName());
                schemaName = info.getTable_owner();
                tableName = info.getTable_name();
            }
        }
        if (monitor.isCanceled()) {
            return false;
        }
        if (SchemaSearcher.isSupport(con)) {
            monitor.subTask(Messages.getString("RefreshColumnJob.6"));
            factory = DefaultColumnSearcherFactory.getFactory(config);
            columns = factory.execute(con, schemaName, tableName);
            monitor.worked(1);
            monitor.subTask("Search for PrimaryKey...");
            constraintFactory = DefaultConstraintSearcherFactory.getFactory(config);
            pks = constraintFactory.getPKColumns(con, schemaName, tableName);
            monitor.worked(1);
            monitor.subTask(Messages.getString("RefreshColumnJob.8"));
            fks = constraintFactory.getFKColumns(con, schemaName, tableName);
            monitor.worked(1);
            switch (DBType.getType(con.getMetaData())) {
                case 1: {
                    monitor.subTask(Messages.getString("RefreshColumnJob.9"));
                    cons = constraintFactory.getConstraintColumns(con, schemaName, tableName);
                    monitor.worked(1);
                    monitor.subTask(Messages.getString("RefreshColumnJob.10"));
                    TableIDXColumn[][] indexies = OracleIndexSearcher.getIDXColumns(con, schemaName, tableName);
                    uidxs = indexies[0];
                    nonuidxs = indexies[1];
                    monitor.worked(2);
                    break;
                }
                default: {
                    monitor.subTask(Messages.getString("RefreshColumnJob.12"));
                    monitor.worked(1);
                    monitor.subTask(Messages.getString("RefreshColumnJob.13"));
                    uidxs = constraintFactory.getUniqueIDXColumns(con, schemaName, tableName, true);
                    monitor.worked(1);
                    monitor.subTask(Messages.getString("RefreshColumnJob.14"));
                    nonuidxs = constraintFactory.getUniqueIDXColumns(con, schemaName, tableName, false);
                    monitor.worked(1);
                    break;
                }
            }
        } else {
            monitor.subTask(Messages.getString("RefreshColumnJob.15"));
            factory = DefaultColumnSearcherFactory.getFactory(config);
            columns = factory.execute(con, null, tableName);
            monitor.worked(1);
            monitor.subTask(Messages.getString("RefreshColumnJob.16"));
            constraintFactory = DefaultConstraintSearcherFactory.getFactory(config);
            pks = constraintFactory.getPKColumns(con, null, tableName);
            monitor.worked(1);
            monitor.subTask(Messages.getString("RefreshColumnJob.17"));
            fks = constraintFactory.getFKColumns(con, null, tableName);
            monitor.worked(1);
            monitor.subTask(Messages.getString("RefreshColumnJob.18"));
            monitor.worked(1);
            monitor.subTask(Messages.getString("RefreshColumnJob.19"));
            uidxs = constraintFactory.getUniqueIDXColumns(con, null, tableName, true);
            monitor.worked(1);
            monitor.subTask(Messages.getString("RefreshColumnJob.20"));
            nonuidxs = constraintFactory.getUniqueIDXColumns(con, null, tableName, false);
            monitor.worked(1);
        }
        if (monitor.isCanceled()) {
            return false;
        }
        table.setTablePKColumns(pks);
        table.setTableFKColumns(fks);
        table.setTableConstraintColumns(cons);
        table.setTableUIDXColumns(uidxs);
        table.setTableNonUIDXColumns(nonuidxs);
        table.removeChild(table.getChild(DbPluginConstant.TREE_LEAF_LOADING));
        ArrayList<String> newColumnList = new ArrayList<String>();
        int i = 0;
        while (i < columns.length) {
            TableColumn w_column = columns[i];
            TablePKColumn w_pk = this.getPKColumn(pks, w_column);
            TableFKColumn[] w_fks = this.getFKColumns(fks, w_column);
            newColumnList.add(w_column.getColumnName());
            TreeLeaf leaf = table.getChild(w_column.getColumnName());
            if (leaf == null) {
                this.addColumn(table, w_column, w_pk, w_fks);
            } else {
                this.updateColumn(table, (Column)leaf, w_column, w_pk, w_fks);
            }
            if (monitor.isCanceled()) {
                return false;
            }
            ++i;
        }
        this.removeDeleteColumn(table, newColumnList);
        table.setExpanded(true);
        tw.stop();
        System.out.println("loadColumnInfo " + tw.getTotalTime());
        return true;
    }

    private void removeDeleteColumn(ITable table, List newColumnList) {
        TreeLeaf[] leafs = table.getChildrens();
        int i = 0;
        while (i < leafs.length) {
            TreeLeaf leaf = leafs[i];
            if (!newColumnList.contains(leaf.getName())) {
                table.removeChild(leaf);
            }
            ++i;
        }
    }

    private void addColumn(ITable table, TableColumn w_column, TablePKColumn w_pk, TableFKColumn[] w_fks) {
        switch (DBType.getType(table.getDbConfig())) {
            case 1: {
                table.addChild(new OracleColumn(w_column, w_pk, w_fks));
                break;
            }
            default: {
                table.addChild(new Column(w_column, w_pk, w_fks));
            }
        }
    }

    private void updateColumn(ITable table, Column oldColumn, TableColumn w_column, TablePKColumn w_pk, TableFKColumn[] w_fks) {
        Column newColumn = null;
        switch (DBType.getType(table.getDbConfig())) {
            case 1: {
                newColumn = new OracleColumn(w_column, w_pk, w_fks);
                break;
            }
            default: {
                newColumn = new Column(w_column, w_pk, w_fks);
            }
        }
        oldColumn.update(newColumn);
    }

    private TablePKColumn getPKColumn(TablePKColumn[] pks, TableColumn column) throws Exception {
        TablePKColumn pk = null;
        int i = 0;
        while (i < pks.length) {
            if (pks[i].getColumnName().equals(column.getColumnName())) {
                pk = pks[i];
                break;
            }
            ++i;
        }
        return pk;
    }

    private TableFKColumn[] getFKColumns(TableFKColumn[] fks, TableColumn column) throws Exception {
        ArrayList<TableFKColumn> list = new ArrayList<TableFKColumn>();
        int i = 0;
        while (i < fks.length) {
            if (fks[i].getColumnName().equals(column.getColumnName())) {
                list.add(fks[i]);
            }
            ++i;
        }
        return list.toArray(new TableFKColumn[0]);
    }
}

