/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.internal;

import java.text.SimpleDateFormat;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.SQLHistory;
import zigen.plugin.db.ui.internal.TreeNode;

public class History
extends TreeNode {
    protected SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
    protected SQLHistory sqlHistory;
    public static final int MAX_LEN = 100;

    public History(SQLHistory history) {
        this.sqlHistory = history;
    }

    public SQLHistory getSqlHistory() {
        return this.sqlHistory;
    }

    public String getTime() {
        return this.timeFormat.format(this.sqlHistory.getDate());
    }

    public String getName() {
        StringBuffer sb = new StringBuffer();
        String shortSql = this.getShortSql();
        if (!"".equals(shortSql)) {
            sb.append(this.getTime());
            sb.append(" ");
            sb.append(this.getShortSql());
        }
        return sb.toString();
    }

    private String getShortSql() {
        String sql = this.sqlHistory.getSql();
        if (sql == null) {
            return "";
        }
        if (sql.length() > 100) {
            return String.valueOf(sql.substring(0, 100)) + "...";
        }
        return sql;
    }

    public IDBConfig getDbConfig() {
        return this.sqlHistory.getConfig();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        History castedObj = (History)o;
        return (this.timeFormat == null ? castedObj.timeFormat == null : this.timeFormat.equals(castedObj.timeFormat)) && (this.sqlHistory == null ? castedObj.sqlHistory == null : this.sqlHistory.equals(castedObj.sqlHistory));
    }
}

