/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.editors.sql;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.CoolBarManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.CursorLinePainter;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IFindReplaceTargetExtension;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.MatchingCharacterPainter;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.editors.text.TextEditor;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.ImageCacher;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.ext.oracle.internal.OracleSourceDetailInfo;
import zigen.plugin.db.ext.oracle.internal.OracleSourceErrorInfo;
import zigen.plugin.db.ui.actions.GlobalAction;
import zigen.plugin.db.ui.actions.OpenSQLAction;
import zigen.plugin.db.ui.actions.SaveSQLAction;
import zigen.plugin.db.ui.editors.sql.IPlsqlEditor;
import zigen.plugin.db.ui.editors.sql.SourceEditorContributor;
import zigen.plugin.db.ui.editors.sql.SourceEditorInput;
import zigen.plugin.db.ui.internal.Root;
import zigen.plugin.db.ui.internal.TreeLeaf;
import zigen.plugin.db.ui.internal.TreeNode;
import zigen.plugin.db.ui.util.LineNumberRulerColumnUtil;
import zigen.plugin.db.ui.util.StyledTextUtil;
import zigen.plugin.db.ui.views.internal.ColorManager;
import zigen.plugin.db.ui.views.internal.PLSQLCodeConfiguration;
import zigen.plugin.db.ui.views.internal.PLSQLSourceViewer;
import zigen.plugin.db.ui.views.internal.SQLCharacterPairMatcher;
import zigen.plugin.db.ui.views.internal.SQLOutinePage;
import zigen.plugin.db.ui.views.internal.SQLPartitionScanner;
import zigen.plugin.db.ui.views.internal.SQLSourceViewer;

public class SourceEditor
extends TextEditor
implements IPlsqlEditor,
IPropertyChangeListener {
    public static final String ID = "zigen.plugin.db.ui.editors.sql.SourceEditor";
    protected IDBConfig config;
    protected PLSQLSourceViewer sourceViewer;
    protected PLSQLCodeConfiguration sqlConfiguration;
    protected OracleSourceDetailInfo sourceDetailInfo;
    protected OracleSourceErrorInfo[] sourceErrorInfos;
    protected ColorManager colorManager;
    protected LineNumberRulerColumn rulerCol;
    protected IPreferenceStore store;
    protected boolean dirty = false;
    protected TreeViewer errorViewer;
    protected SashForm sash;
    protected CursorLinePainter cpainter;
    protected MatchingCharacterPainter painter;
    protected Color fFindScopeHighlightColor;
    GlobalAction execScriptAction = new GlobalAction(null, 1013);
    OpenSQLAction openSQLAction = new OpenSQLAction(null);
    SaveSQLAction saveSQLAction = new SaveSQLAction(null);
    CoolBar coolBar;
    ProjectionSupport projectionSupport;
    Document document;
    SQLOutinePage outlinePage;

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        super.init(site, editorInput);
        if (editorInput instanceof SourceEditorInput) {
            SourceEditorInput input = (SourceEditorInput)editorInput;
            this.sourceDetailInfo = input.getSourceDetailInfo();
            this.sourceErrorInfos = input.getSourceErrorInfos();
            this.config = input.getConfig();
            this.setPartName(input.getName());
            this.colorManager = new ColorManager();
            this.sqlConfiguration = new PLSQLCodeConfiguration(this.colorManager);
            this.setSourceViewerConfiguration(this.sqlConfiguration);
            this.store = DbPlugin.getDefault().getPreferenceStore();
            this.store.addPropertyChangeListener((IPropertyChangeListener)this);
            this.document = (Document)this.getDocumentProvider().getDocument((Object)editorInput);
        }
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.sourceViewer = (PLSQLSourceViewer)this.getSourceViewer();
        DbPlugin.getDefault().getPreferenceStore().getString("SQLEditorPreferencePage.SqlDemiliter");
        IDocument doc = this.sourceViewer.getDocument();
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new SQLPartitionScanner(), new String[]{"__sql_string", "__sql_comment"});
        partitioner.connect(doc);
        doc.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        PLSQLSourceViewer extension = this.sourceViewer;
        MatchingCharacterPainter painter = new MatchingCharacterPainter((ISourceViewer)this.sourceViewer, (ICharacterPairMatcher)new SQLCharacterPairMatcher());
        painter.setColor(this.colorManager.getColor("SQLEditorPreferencePage.ColorMatching"));
        extension.addPainter((IPainter)painter);
        ProjectionViewer pviewer = (ProjectionViewer)this.getSourceViewer();
        this.projectionSupport = new ProjectionSupport(pviewer, this.getAnnotationAccess(), this.getSharedColors());
        this.projectionSupport.install();
        pviewer.doOperation(19);
        StyledTextUtil.changeColor(this.colorManager, this.sourceViewer.getTextWidget());
        this.hookContextMenu();
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        Composite content = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        content.setLayout((Layout)layout);
        this.createToolbarPart(content);
        this.sash = new SashForm(content, 512);
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.coolBar, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        this.sash.setLayoutData((Object)data);
        this.sourceViewer = new PLSQLSourceViewer((Composite)this.sash, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)this.sourceViewer);
        data = new FormData();
        data.top = new FormAttachment(100, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        this.sourceViewer.setPlsqlEditor(this);
        this.initializeViewerFont((ISourceViewer)this.sourceViewer);
        this.errorViewer = new TreeViewer((Composite)this.sash, 66306);
        data = new FormData();
        data.top = new FormAttachment(100, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        this.errorViewer.getControl().setLayoutData((Object)data);
        this.errorViewer.getTree().setLinesVisible(true);
        ErrorContentProvider cp = new ErrorContentProvider();
        this.errorViewer.setContentProvider((IContentProvider)cp);
        this.errorViewer.setLabelProvider((IBaseLabelProvider)new ErrorLabelProvider());
        this.errorViewer.setInput((Object)this.sourceErrorInfos);
        this.errorViewer.expandAll();
        this.sash.setWeights(new int[]{80, 20});
        this.hookContextMenu();
        this.setSQLViewerToAction(this.sourceViewer);
        return this.sourceViewer;
    }

    protected void initializeViewerFont(ISourceViewer viewer) {
        StyledText styledText = viewer.getTextWidget();
        styledText.setFont(DbPlugin.getDefaultFont());
    }

    public void createToolbarPart(final Composite parent) {
        this.coolBar = new CoolBar(parent, 0);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        this.coolBar.setLayoutData((Object)data);
        CoolBarManager coolBarMgr = new CoolBarManager(this.coolBar);
        ToolBarManager toolBarMgr1 = new ToolBarManager(0x800000);
        toolBarMgr1.add((IAction)this.execScriptAction);
        ToolBarManager toolBarMgr2 = new ToolBarManager(0x800000);
        toolBarMgr2.add((IAction)this.openSQLAction);
        toolBarMgr2.add((IAction)this.saveSQLAction);
        coolBarMgr.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)toolBarMgr2));
        coolBarMgr.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)toolBarMgr1));
        coolBarMgr.update(true);
        this.coolBar.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                parent.getParent().layout(true);
                parent.layout(true);
            }
        });
    }

    private void setSQLViewerToAction(SQLSourceViewer viewer) {
        this.execScriptAction.setTextViewer((TextViewer)viewer);
        this.openSQLAction.setSQLSourceViewer(viewer);
        this.saveSQLAction.setSQLSourceViewer(viewer);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                SourceEditor.this.getContributor().fillContextMenu(manager);
            }
        });
        StyledText text = this.sourceViewer.getTextWidget();
        Menu menu = menuMgr.createContextMenu((Control)text);
        text.setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.sourceViewer);
    }

    private SourceEditorContributor getContributor() {
        IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
        if (contributor instanceof SourceEditorContributor) {
            return (SourceEditorContributor)contributor;
        }
        return null;
    }

    public String getEditingSource() {
        return this.getSourceViewer().getDocument().get();
    }

    protected IStatusLineManager getIStatusLineManager() {
        IEditorSite site = super.getEditorSite();
        IActionBars actionBars = site.getActionBars();
        return actionBars.getStatusLineManager();
    }

    public void dispose() {
        super.dispose();
        this.colorManager.dispose();
        DbPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.sqlConfiguration != null && this.sourceViewer != null) {
            this.sqlConfiguration.updatePreferences(this.sourceViewer.getDocument());
            StyledTextUtil.changeColor(this.colorManager, this.sourceViewer.getTextWidget());
            this.sourceViewer.invalidateTextPresentation();
            this.cpainter.setHighlightColor(this.colorManager.getColor("SQLEditorPreferencePage.CursorLine"));
            StyledTextUtil.changeColor(this.colorManager, this.sourceViewer.getTextWidget());
            LineNumberRulerColumnUtil.changeColor(this.colorManager, this.rulerCol);
            this.sqlConfiguration.updatePreferences(this.sourceViewer.getDocument());
            this.painter.setColor(this.colorManager.getColor("SQLEditorPreferencePage.ColorMatching"));
            this.cpainter.setHighlightColor(this.colorManager.getColor("SQLEditorPreferencePage.CursorLine"));
            String property = event.getProperty();
            if ("SQLEditorPreferencePage.ColorFindScope".equals(property)) {
                this.initializeFindScopeColor((ISourceViewer)this.sourceViewer);
            }
            this.sourceViewer.invalidateTextPresentation();
        }
    }

    private void initializeFindScopeColor(ISourceViewer viewer) {
        IPreferenceStore store = DbPlugin.getDefault().getPreferenceStore();
        if (store != null) {
            Color color = this.colorManager.getColor("SQLEditorPreferencePage.ColorFindScope");
            IFindReplaceTarget target = viewer.getFindReplaceTarget();
            if (target != null && target instanceof IFindReplaceTargetExtension) {
                ((IFindReplaceTargetExtension)target).setScopeHighlightColor(color);
            }
            if (this.fFindScopeHighlightColor != null) {
                this.fFindScopeHighlightColor.dispose();
            }
            this.fFindScopeHighlightColor = color;
        }
    }

    protected void setGlobalAction() {
        IActionBars actionbars = this.getEditorSite().getActionBars();
        actionbars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)new GlobalAction((TextViewer)this.sourceViewer, 1));
        actionbars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)new GlobalAction((TextViewer)this.sourceViewer, 2));
        actionbars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)new GlobalAction((TextViewer)this.sourceViewer, 6));
        actionbars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)new GlobalAction((TextViewer)this.sourceViewer, 7));
        actionbars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)new GlobalAction((TextViewer)this.sourceViewer, 4));
        actionbars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)new GlobalAction((TextViewer)this.sourceViewer, 5));
        actionbars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)new GlobalAction((TextViewer)this.sourceViewer, 3));
    }

    public void setFocus() {
        this.setGlobalAction();
    }

    public IDBConfig getConfig() {
        return this.config;
    }

    public PLSQLSourceViewer getPLSQLSourceViewer() {
        return this.sourceViewer;
    }

    public Object getAdapter(Class adapter) {
        Object obj;
        if (this.projectionSupport != null && (obj = this.projectionSupport.getAdapter(this.getSourceViewer(), adapter)) != null) {
            return obj;
        }
        return super.getAdapter(adapter);
    }

    public void doSave(IProgressMonitor progressMonitor) {
        super.doSave(progressMonitor);
        this.saveSQLAction.run();
    }

    public void doSaveAs() {
        super.doSaveAs();
        this.saveSQLAction.run();
    }

    public void setError(OracleSourceErrorInfo[] OracleSourceErrorInfos) {
        this.errorViewer.setInput((Object)OracleSourceErrorInfos);
        this.errorViewer.expandAll();
    }

    public void clearError() {
        this.errorViewer.setInput(null);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public class ErrorLabelProvider
    extends LabelProvider {
        ImageCacher ic = ImageCacher.getInstance();

        public String getText(Object obj) {
            return obj.toString();
        }

        public Image getImage(Object obj) {
            if (obj instanceof Root) {
                return this.ic.getImage("error_root.gif");
            }
            return this.ic.getImage("error.gif");
        }
    }

    private class ErrorContentProvider
    implements ITreeContentProvider {
        private Root invisibleRoot;
        private TreeViewer viewer;

        private ErrorContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            this.viewer = (TreeViewer)v;
            this.invisibleRoot = new Root("invisible", true);
            if (newInput instanceof OracleSourceErrorInfo[]) {
                OracleSourceErrorInfo[] errors = (OracleSourceErrorInfo[])newInput;
                Root root = new Root("Errors (" + errors.length + " items)");
                this.invisibleRoot.addChild(root);
                int i = 0;
                while (i < errors.length) {
                    OracleSourceErrorInfo err = errors[i];
                    root.addChild(new TreeNode(err.getErrorText()));
                    ++i;
                }
            }
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(this.invisibleRoot);
        }

        public Object getParent(Object element) {
            if (element instanceof TreeLeaf) {
                return ((TreeLeaf)element).getParent();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof TreeNode) {
                return ((TreeNode)parentElement).getChildrens();
            }
            return new Object[0];
        }

        public boolean hasChildren(Object element) {
            if (element instanceof TreeNode) {
                return ((TreeNode)element).hasChildren();
            }
            return false;
        }

        public Root getInvisibleRoot() {
            return this.invisibleRoot;
        }
    }
}

