/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.editors.internal.wizard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.ColumnSeqSorter;
import zigen.plugin.db.core.rule.ISQLCreatorFactory;
import zigen.plugin.db.ui.editors.event.TextSelectionListener;
import zigen.plugin.db.ui.editors.internal.wizard.DefaultWizardPage;
import zigen.plugin.db.ui.editors.internal.wizard.Messages;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.util.WidgetUtil;
import zigen.plugin.db.ui.views.TreeViewSorter;

public class PKWizardPage
extends DefaultWizardPage {
    public static final String MSG_DSC = Messages.getString("PKWizardPage.0");
    private static final String MSG_REQUIRE_NAME = Messages.getString("PKWizardPage.1");
    private static final String MSG_REQUIRE_COLUMN = Messages.getString("PKWizardPage.2");
    protected ISQLCreatorFactory factory;
    protected ITable tableNode;
    protected Text txtConstraintName;
    protected List selectedList = new ArrayList();
    protected List columnList = new ArrayList();
    protected TableViewer selectColumnViewer;
    protected TableViewer columnViewer;

    public PKWizardPage(ISQLCreatorFactory factory, ITable table) {
        super(Messages.getString("PKWizardPage.3"));
        this.setTitle(Messages.getString("PKWizardPage.4"));
        this.factory = factory;
        this.tableNode = table;
        Column[] columns = table.getColumns();
        int i = 0;
        while (i < columns.length) {
            this.columnList.add(columns[i]);
            ++i;
        }
    }

    public void createControl(Composite parent) {
        Composite container = this.createDefaultComposite(parent);
        this.createNameConstrol(container);
        this.createColumnSelectConstrol(container);
        this.createOptionControl(container);
        this.setControl((Control)container);
    }

    protected void createNameConstrol(Composite container) {
        Composite composite = new Composite(container, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite, 0);
        label.setText(Messages.getString("PKWizardPage.5"));
        this.txtConstraintName = new Text(composite, 2048);
        GridData gd = new GridData(768);
        this.txtConstraintName.setLayoutData((Object)gd);
        this.txtConstraintName.setText("");
        this.txtConstraintName.addFocusListener((FocusListener)new TextSelectionListener());
        this.txtConstraintName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if ("".equals(PKWizardPage.this.txtConstraintName.getText())) {
                    PKWizardPage.this.updateStatus(MSG_REQUIRE_NAME);
                } else if (PKWizardPage.this.selectedList.isEmpty()) {
                    PKWizardPage.this.updateStatus(MSG_REQUIRE_COLUMN);
                } else {
                    PKWizardPage.this.updateStatus(null);
                }
            }
        });
    }

    protected void createColumnSelectConstrol(Composite container) {
        Composite main = new Composite(container, 0);
        main.setLayout((Layout)new GridLayout(3, false));
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        gd.widthHint = 400;
        main.setLayoutData((Object)gd);
        Label label1 = new Label(main, 0);
        label1.setText(Messages.getString("PKWizardPage.8"));
        new Label(main, 0);
        Label label2 = new Label(main, 0);
        label2.setText(Messages.getString("PKWizardPage.9"));
        this.columnViewer = new TableViewer(main, 67586);
        gd = new GridData(1808);
        gd.heightHint = 100;
        gd.widthHint = 200;
        final Table table2 = this.columnViewer.getTable();
        table2.setLayoutData((Object)gd);
        table2.setHeaderVisible(false);
        table2.setLinesVisible(false);
        table2.setFont(DbPlugin.getDefaultFont());
        this.columnViewer.setContentProvider((IContentProvider)new DefaultWizardPage.ConstraintsColumnContentProvider());
        this.columnViewer.setLabelProvider((IBaseLabelProvider)new DefaultWizardPage.ConstraintsColumnLabelProvider());
        this.columnViewer.setSorter((ViewerSorter)new TreeViewSorter());
        this.setHeaderColumn(table2);
        this.columnViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TableItem[] items = table2.getSelection();
                int i = 0;
                while (i < items.length) {
                    TableItem item = items[i];
                    Column col = (Column)item.getData();
                    PKWizardPage.this.selectedList.add(col);
                    PKWizardPage.this.columnList.remove(col);
                    ++i;
                }
                PKWizardPage.this.update();
            }
        });
        Composite ButtonArea = new Composite(main, 0);
        ButtonArea.setLayout((Layout)new GridLayout(1, false));
        int BUTTON_WIDTH = 50;
        Button addBtn = WidgetUtil.createButton(ButtonArea, 8, ">>", BUTTON_WIDTH, new GridData());
        Button addBtn2 = WidgetUtil.createButton(ButtonArea, 8, ">", BUTTON_WIDTH, new GridData());
        Button addBtn3 = WidgetUtil.createButton(ButtonArea, 8, "<", BUTTON_WIDTH, new GridData());
        Button addBtn4 = WidgetUtil.createButton(ButtonArea, 8, "<<", BUTTON_WIDTH, new GridData());
        this.selectColumnViewer = new TableViewer(main, 67586);
        gd = new GridData(1808);
        gd.heightHint = 100;
        gd.widthHint = 200;
        final Table table = this.selectColumnViewer.getTable();
        table.setLayoutData((Object)gd);
        table.setHeaderVisible(false);
        table.setLinesVisible(false);
        table.setFont(DbPlugin.getDefaultFont());
        this.setHeaderColumn(table);
        this.selectColumnViewer.setContentProvider((IContentProvider)new DefaultWizardPage.ConstraintsColumnContentProvider());
        this.selectColumnViewer.setLabelProvider((IBaseLabelProvider)new DefaultWizardPage.ConstraintsColumnLabelProvider());
        this.selectColumnViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TableItem[] items = table.getSelection();
                int i = 0;
                while (i < items.length) {
                    TableItem item = items[i];
                    Column col = (Column)item.getData();
                    PKWizardPage.this.selectedList.remove(col);
                    PKWizardPage.this.columnList.add(col);
                    ++i;
                }
                PKWizardPage.this.update();
            }
        });
        addBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                while (!PKWizardPage.this.columnList.isEmpty()) {
                    Column col = (Column)PKWizardPage.this.columnList.get(0);
                    PKWizardPage.this.selectedList.add(col);
                    PKWizardPage.this.columnList.remove(col);
                }
                PKWizardPage.this.update();
            }
        });
        addBtn2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items = table2.getSelection();
                int i = 0;
                while (i < items.length) {
                    TableItem item = items[i];
                    Column col = (Column)item.getData();
                    PKWizardPage.this.selectedList.add(col);
                    PKWizardPage.this.columnList.remove(col);
                    ++i;
                }
                PKWizardPage.this.update();
            }
        });
        addBtn3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items = table.getSelection();
                int i = 0;
                while (i < items.length) {
                    TableItem item = items[i];
                    Column col = (Column)item.getData();
                    PKWizardPage.this.selectedList.remove(col);
                    PKWizardPage.this.columnList.add(col);
                    ++i;
                }
                PKWizardPage.this.update();
            }
        });
        addBtn4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                while (!PKWizardPage.this.selectedList.isEmpty()) {
                    Column col = (Column)PKWizardPage.this.selectedList.get(0);
                    PKWizardPage.this.selectedList.remove(col);
                    PKWizardPage.this.columnList.add(col);
                }
                PKWizardPage.this.update();
            }
        });
    }

    protected void createOptionControl(Composite container) {
    }

    protected void update() {
        Collections.sort(this.columnList, new ColumnSeqSorter());
        this.selectColumnViewer.setInput((Object)this.selectedList.toArray(new Column[0]));
        this.columnViewer.setInput((Object)this.columnList.toArray(new Column[0]));
        this.columnsPack(this.selectColumnViewer.getTable());
        this.columnsPack(this.columnViewer.getTable());
        if ("".equals(this.txtConstraintName.getText())) {
            this.updateStatus(MSG_REQUIRE_NAME);
        } else if (this.selectedList.isEmpty()) {
            this.updateStatus(MSG_REQUIRE_COLUMN);
        } else {
            this.updateStatus(null);
        }
    }

    protected void setHeaderColumn(Table table) {
        TableColumn col1 = new TableColumn(table, 0);
        col1.setText("dummy");
        col1.pack();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setDescription(MSG_DSC);
            this.update();
        }
    }
}

