/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.editors.internal.wizard;

import java.util.ArrayList;
import org.eclipse.jface.wizard.IWizardPage;
import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.core.rule.ISQLCreatorFactory;
import zigen.plugin.db.ui.editors.internal.wizard.ColumnWizardPage;
import zigen.plugin.db.ui.editors.internal.wizard.DefaultWizard;
import zigen.plugin.db.ui.editors.internal.wizard.IConfirmDDLWizard;
import zigen.plugin.db.ui.editors.internal.wizard.Messages;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.ITable;

public class ColumnWizard
extends DefaultWizard
implements IConfirmDDLWizard {
    private ColumnWizardPage page1;
    private Column column;
    private Column newColumn;
    private boolean isAddColumn = false;

    public ColumnWizard(ISQLCreatorFactory factory, ITable tableNode, Column column, boolean isAddColumn) {
        super(factory, tableNode);
        if (isAddColumn) {
            super.setWindowTitle(Messages.getString("ColumnWizard.0"));
        } else {
            super.setWindowTitle(Messages.getString("ColumnWizard.1"));
        }
        this.column = column;
        this.isAddColumn = isAddColumn;
        this.setNeedsProgressMonitor(true);
        this.setHelpAvailable(false);
    }

    public void addPages() {
        this.page1 = new ColumnWizardPage(this.factory, this.tableNode, this.column, this.isAddColumn);
        this.addPage((IWizardPage)this.page1);
        this.addPage((IWizardPage)this.confirmPage);
    }

    public boolean canFinish() {
        return this.page1.isPageComplete() && this.confirmPage.isPageComplete();
    }

    public String[] createSQL() throws Exception {
        Column newColumn = new Column(new TableColumn());
        newColumn.setParent(this.column.getParent());
        newColumn.setName(this.page1.txtColumnName.getText());
        newColumn.setTypeName(this.page1.cmbColumnType.getText());
        if (this.factory.isVisibleColumnSize(this.page1.cmbColumnType.getText())) {
            newColumn.setSize(this.page1.txtColumnSize.getText());
            if ("".equals(this.page1.txtColumnSize.getText())) {
                newColumn.getColumn().setWithoutParam(true);
            }
        }
        newColumn.setDefaultValue(this.page1.txtDefualtt.getText());
        newColumn.setRemark(this.page1.txtColumnComment.getText());
        newColumn.setNotNull(this.page1.chkNotNull.getSelection());
        ArrayList<String> list = new ArrayList<String>();
        if (this.isAddColumn) {
            String[] sqls = this.factory.createAddColumnDDL(newColumn);
            int i = 0;
            while (i < sqls.length) {
                list.add(sqls[i]);
                ++i;
            }
            list.add(this.factory.createCommentOnColumnDDL(newColumn));
        } else {
            if (!this.column.getName().equals(newColumn.getName())) {
                list.add(this.factory.createRenameColumnDDL(this.column, newColumn));
            }
            if (!(this.column.getTypeName().equals(newColumn.getTypeName()) && this.column.getSize().equals(newColumn.getSize()) && this.column.getDefaultValue().equals(newColumn.getDefaultValue()) && this.column.isNotNull() == newColumn.isNotNull())) {
                String[] sqls = this.factory.createModifyColumnDDL(this.column, newColumn);
                int i = 0;
                while (i < sqls.length) {
                    list.add(sqls[i]);
                    ++i;
                }
            }
            if (!this.column.getRemarks().equals(newColumn.getRemarks())) {
                list.add(this.factory.createCommentOnColumnDDL(newColumn));
            }
        }
        return list.toArray(new String[0]);
    }
}

