/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.editors.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import org.eclipse.jface.viewers.TableViewer;
import zigen.plugin.db.core.TableElement;
import zigen.plugin.db.core.TimeWatcher;

public class TableViewerManager {
    public static void insert(TableViewer viewer, TableElement newElement) {
        Object obj = viewer.getInput();
        if (!(obj instanceof TableElement[])) {
            throw new IllegalArgumentException("TableViewer\u306b\u683c\u7d0d\u3055\u308c\u3066\u3044\u308b\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304c\u7570\u306a\u308a\u307e\u3059");
        }
        TableElement[] old = (TableElement[])viewer.getInput();
        TableElement[] wk = new TableElement[old.length + 1];
        System.arraycopy(old, 0, wk, 0, old.length);
        wk[old.length] = newElement;
        viewer.setInput((Object)wk);
    }

    public static void update(TableViewer viewer, TableElement from, TableElement to) {
        Object obj = viewer.getInput();
        TimeWatcher tw = new TimeWatcher();
        tw.start();
        if (obj instanceof TableElement[]) {
            TableElement[] elements = (TableElement[])viewer.getInput();
            int i = 1;
            while (i < elements.length) {
                if (elements[i].equals(from)) {
                    TableElement ele = elements[i];
                    ele.copy(to);
                    ele.clearMofiedColumn();
                    ele.setRecordNo(from.getRecordNo());
                    ele.isNew(false);
                    viewer.update((Object)ele, null);
                    break;
                }
                ++i;
            }
        } else {
            throw new IllegalArgumentException("TableViewer\u306b\u683c\u7d0d\u3055\u308c\u3066\u3044\u308b\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304c\u7570\u306a\u308a\u307e\u3059");
        }
        tw.stop();
    }

    public static void remove(TableViewer viewer, Object target) {
        ArrayList<TableElement> newList;
        Object obj = viewer.getInput();
        if (obj instanceof TableElement[]) {
            TableElement[] elements = (TableElement[])viewer.getInput();
            newList = new ArrayList<TableElement>();
            int i = 0;
            while (i < elements.length) {
                if (!elements[i].equals(target)) {
                    newList.add(elements[i]);
                }
                ++i;
            }
        } else {
            throw new IllegalArgumentException("TableViewer\u306b\u683c\u7d0d\u3055\u308c\u3066\u3044\u308b\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304c\u7570\u306a\u308a\u307e\u3059");
        }
        viewer.setInput((Object)newList.toArray(new TableElement[0]));
    }

    public static void remove(TableViewer viewer, Object[] target) {
        TableElement[] contents = (TableElement[])viewer.getInput();
        LinkedList<TableElement> srcList = new LinkedList<TableElement>(Arrays.asList(contents));
        int i = 0;
        while (i < target.length) {
            srcList.remove(target[i]);
            ++i;
        }
        contents = srcList.toArray(new TableElement[srcList.size()]);
        viewer.setInput((Object)contents);
    }
}

