/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.dialogs;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.DBType;
import zigen.plugin.db.core.DriverSearcherThread;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.PluginClassLoader;
import zigen.plugin.db.preference.URLPreferencePage;
import zigen.plugin.db.ui.dialogs.DBConfigWizard;
import zigen.plugin.db.ui.dialogs.DefaultWizardPage;
import zigen.plugin.db.ui.dialogs.Messages;
import zigen.plugin.db.ui.dialogs.WizardPage1;
import zigen.plugin.db.ui.editors.event.TextSelectionListener;
import zigen.plugin.db.ui.jobs.TestConnectThread;
import zigen.plugin.db.ui.util.WidgetUtil;

public class WizardPage2
extends DefaultWizardPage {
    public static final String MSG = Messages.getString("WizardPage2.0");
    Combo driverCombox;
    Text urlText;
    Text userIdText;
    Text schemaText;
    Text passwordText;
    Button radio4;
    Button radio2;
    Button savePassword;
    Button testBtn;
    boolean searchDriverFlg = true;
    protected IPreferenceStore store;
    Composite container;
    Combo connectionModeCombox;
    Combo connectionModeCombox2;
    Group group;

    public WizardPage2(ISelection selection) {
        super(Messages.getString("WizardPage2.1"));
        this.setTitle(Messages.getString("WizardPage2.2"));
        this.setPageComplete(true);
        this.store = DbPlugin.getDefault().getPreferenceStore();
    }

    public void createControl(Composite parent) {
        this.container = this.createDefaultComposite(parent);
        this.group = new Group(this.container, 0);
        this.group.setText(Messages.getString("WizardPage2.3"));
        this.group.setLayoutData((Object)new GridData(768));
        this.group.setLayout((Layout)new GridLayout(2, false));
        this.addDriverSection((Composite)this.group);
        this.addTypeSection((Composite)this.group);
        this.addURLSection((Composite)this.group);
        this.addUseridSection((Composite)this.group);
        this.addPasswordSection((Composite)this.group);
        this.addSchemaSection((Composite)this.group);
        this.addTestConnectSection((Composite)this.group);
        this.setControl((Control)this.container);
    }

    private void addDriverSection(Composite group) {
        Label urlLabel = new Label(group, 0);
        urlLabel.setText(Messages.getString("WizardPage2.4"));
        this.driverCombox = new Combo(group, 8);
        this.driverCombox.setLayoutData((Object)new GridData(768));
        this.driverCombox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WizardPage2.this.modified();
                Combo comb = (Combo)e.widget;
                if (comb.getText().indexOf("OracleDriver") >= 0) {
                    if (WizardPage2.this.schemaText != null && WizardPage2.this.userIdText != null) {
                        WizardPage2.this.schemaText.setText(WizardPage2.this.userIdText.getText());
                        WizardPage2.this.schemaText.setEnabled(false);
                    }
                } else if (WizardPage2.this.schemaText != null && comb.getText().indexOf("mysql") >= 0) {
                    WizardPage2.this.schemaText.setEnabled(false);
                }
                WizardPage2.this.setDefaultURLString(WizardPage2.this.driverCombox.getText());
            }
        });
        if (this.getOldConfig() != null) {
            IDBConfig old = this.getOldConfig();
            this.driverCombox.add(old.getDriverName());
            this.driverCombox.select(0);
        }
    }

    private void addTypeSection(Composite group) {
        Label label2 = new Label(group, 0);
        label2.setText(Messages.getString("WizardPage2.6"));
        Composite left = new Composite(group, 0);
        left.setLayout((Layout)new GridLayout(2, false));
        this.radio4 = new Button(left, 16);
        this.radio4.setText(Messages.getString("WizardPage2.7"));
        this.radio2 = new Button(left, 16);
        this.radio2.setText(Messages.getString("WizardPage2.8"));
        if (this.getOldConfig() != null) {
            if (this.getOldConfig().getJdbcType() == 2) {
                this.radio2.setSelection(true);
                this.radio4.setSelection(false);
            } else {
                this.radio2.setSelection(false);
                this.radio4.setSelection(true);
            }
        } else {
            this.radio2.setSelection(false);
            this.radio4.setSelection(true);
        }
    }

    private void addURLSection(Composite group) {
        Label urlLabel = new Label(group, 0);
        urlLabel.setText(Messages.getString("WizardPage2.9"));
        this.urlText = new Text(group, 2052);
        this.urlText.setLayoutData((Object)new GridData(768));
        this.urlText.addFocusListener((FocusListener)new TextSelectionListener());
        this.urlText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WizardPage2.this.modified();
                if (WizardPage2.this.driverCombox != null && WizardPage2.this.driverCombox.getText().indexOf("mysql") >= 0 && WizardPage2.this.schemaText != null) {
                    String url = WizardPage2.this.urlText.getText();
                    String[] wk = url.split("/");
                    if (wk.length >= 4) {
                        String s = wk[3];
                        int index = s.indexOf(63);
                        if (index >= 0) {
                            WizardPage2.this.schemaText.setText(s.substring(0, index));
                        } else {
                            WizardPage2.this.schemaText.setText(s);
                        }
                    } else {
                        WizardPage2.this.schemaText.setText("");
                    }
                    WizardPage2.this.schemaText.setEnabled(false);
                }
            }
        });
        this.urlText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                super.keyReleased(e);
            }
        });
        if (this.getOldConfig() != null) {
            this.urlText.setText(this.getOldConfig().getUrl());
        } else {
            this.urlText.setText(this.DEFAULT_URL);
        }
    }

    private void addUseridSection(Composite group) {
        Label urlLabel = new Label(group, 0);
        urlLabel.setText(Messages.getString("WizardPage2.10"));
        this.userIdText = new Text(group, 2052);
        this.userIdText.setLayoutData((Object)new GridData(768));
        this.userIdText.addFocusListener((FocusListener)new TextSelectionListener());
        this.userIdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                WizardPage2.this.modified();
                Text text = (Text)evt.widget;
                if (WizardPage2.this.schemaText != null) {
                    WizardPage2.this.schemaText.setText(text.getText());
                }
            }
        });
        if (this.getOldConfig() != null) {
            this.userIdText.setText(this.getOldConfig().getUserId());
        } else {
            this.userIdText.setText(this.DEFAULT_USERID);
        }
    }

    private void addPasswordSection(Composite group) {
        Label urlLabel = new Label(group, 0);
        urlLabel.setText(Messages.getString("WizardPage2.11"));
        this.passwordText = new Text(group, 2052);
        this.passwordText.setLayoutData((Object)new GridData(768));
        this.passwordText.addFocusListener((FocusListener)new TextSelectionListener());
        this.passwordText.setEchoChar('*');
        if (this.getOldConfig() != null) {
            this.passwordText.setText(this.getOldConfig().getPassword());
        } else {
            this.passwordText.setText(this.DEFAULT_PASS);
        }
    }

    private void addSchemaSection(Composite group) {
        Label urlLabel = new Label(group, 0);
        urlLabel.setText(Messages.getString("WizardPage2.12"));
        this.schemaText = new Text(group, 2052);
        this.schemaText.setLayoutData((Object)new GridData(768));
        this.schemaText.addFocusListener((FocusListener)new TextSelectionListener());
        if (this.getOldConfig() != null) {
            this.schemaText.setText(this.getOldConfig().getSchema());
        } else {
            this.schemaText.setText(this.DEFAULT_SCHEMA);
        }
    }

    private void addSavePassowrdSection(Composite group) {
        new Label(group, 0);
        this.savePassword = new Button(group, 32);
        this.savePassword.setText(Messages.getString("WizardPage2.13"));
        if (this.getOldConfig() != null) {
            this.savePassword.setSelection(this.getOldConfig().isSavePassword());
        } else {
            this.savePassword.setSelection(this.DEFAULT_SAVEPASSWORD);
        }
    }

    private void addTestConnectSection(Composite group) {
        new Label(group, 0);
        this.testBtn = WidgetUtil.createButton(group, 8, Messages.getString("WizardPage2.14"), this.BUTTON_WIDTH, new GridData());
        this.testBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardPage2.this.pressTestBtn();
            }
        });
    }

    private void pressTestBtn() {
        IDBConfig config = ((DBConfigWizard)this.getWizard()).createNewConfig();
        int timeout = this.store.getInt("PreferencePage.ConnectTimeout");
        TestConnectThread t = new TestConnectThread(config, timeout);
        Thread th = new Thread(t);
        th.start();
        try {
            if (timeout > 0) {
                th.join(timeout * 1000);
            } else {
                th.join();
            }
        }
        catch (InterruptedException e) {
            DbPlugin.log(e);
        }
        if (t.isSuccess()) {
            super.setMessage(t.getMessage(), 1);
        } else {
            super.setMessage(t.getMessage(), 3);
        }
    }

    private void updateComboBox(List classpathList) {
        this.driverCombox.removeAll();
        try {
            String[] classpaths = classpathList.toArray(new String[0]);
            String[] drivers = this.searchDriver(this.getShell(), classpaths);
            if (drivers == null || drivers.length == 0) {
                this.updateStatus(Messages.getString("WizardPage2.15"));
            } else {
                int i = 0;
                while (i < drivers.length) {
                    String string = drivers[i];
                    this.driverCombox.add(string);
                    if (this.getOldConfig() == null) {
                        if (i == 0) {
                            this.driverCombox.select(i);
                        }
                        this.driverCombox.select(0);
                    } else if (string.equals(this.getOldConfig().getDriverName())) {
                        this.driverCombox.select(i);
                    }
                    ++i;
                }
            }
        }
        catch (InterruptedException e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }

    private void createClassPathList(List list, String folderName, File dir) {
        if (dir.isDirectory()) {
            File[] files = dir.listFiles();
            int i = 0;
            while (i < files.length) {
                File file = files[i];
                if (file.isDirectory()) {
                    this.createClassPathList(list, folderName, file);
                } else if (file.isFile()) {
                    String path = file.getPath();
                    path = path.replace('\\', '/');
                    path = path.replaceAll(String.valueOf(folderName.replace('\\', '/')) + "/", "");
                    list.add(path);
                }
                ++i;
            }
        }
    }

    private File[] toFiles(String[] classpaths) {
        File[] files = new File[classpaths.length];
        int i = 0;
        while (i < classpaths.length) {
            files[i] = new File(classpaths[i]);
            ++i;
        }
        return files;
    }

    private String[] searchDriver(Shell shell, String[] classpaths) throws InterruptedException {
        File[] files = this.toFiles(classpaths);
        ArrayList<String> driverList = new ArrayList<String>();
        int j = 0;
        while (j < files.length) {
            File f = files[j];
            if (f.isDirectory()) {
                this.createClassPathList(driverList, f.getPath(), f);
            } else {
                driverList.add(f.getPath());
            }
            ++j;
        }
        String[] driverClassPath = driverList.toArray(new String[0]);
        PluginClassLoader loader = PluginClassLoader.getClassLoader(classpaths, ((Object)((Object)this)).getClass().getClassLoader());
        DriverSearcherThread thread = new DriverSearcherThread(loader, driverClassPath);
        thread.run();
        List list = thread.getDriverNames();
        return list.toArray(new String[0]);
    }

    private void modified() {
        super.setMessage(null);
        int selectIndex = 0;
        try {
            if (this.testBtn != null) {
                this.testBtn.setEnabled(false);
            }
            if (this.driverCombox != null && (selectIndex = this.driverCombox.getSelectionIndex()) >= 0 && this.urlText != null && this.userIdText != null) {
                String url = this.urlText.getText().trim();
                this.userIdText.getText().trim();
                String driver = this.driverCombox.getItem(selectIndex).trim();
                if (!"".equals(url) && !"".equals(driver)) {
                    if (url.matches(".*<.*|.*>.*")) {
                        super.updateStatus(Messages.getString("WizardPage2.21"));
                    } else {
                        super.updateStatus(null);
                        if (this.testBtn != null) {
                            this.testBtn.setEnabled(true);
                        }
                    }
                } else if (url.matches(".*<.*|.*>.*")) {
                    super.updateStatus(Messages.getString("WizardPage2.23"));
                } else if ("".equals(url)) {
                    super.updateStatus(Messages.getString("WizardPage2.25"));
                } else if ("".equals(driver)) {
                    super.updateStatus(Messages.getString("WizardPage2.27"));
                }
            }
        }
        catch (Exception e) {
            DbPlugin.log(e);
        }
    }

    private void setDefaultURLString(String driverString) {
        if (driverString != null && !"".equals(driverString)) {
            String oldDriver = this.getOldConfig() == null ? "" : this.getOldConfig().getDriverName();
            String checkDriver = driverString.toLowerCase();
            if (!oldDriver.equals(driverString)) {
                List list = URLPreferencePage.getURLTemplates();
                int i = 0;
                while (i < list.size()) {
                    String[] wk = (String[])list.get(i);
                    if (checkDriver.equals(wk[0].toLowerCase())) {
                        if (DbPlugin.getDefault().confirmDialog(Messages.getString("WizardPage2.30"))) {
                            this.urlText.setText(wk[1]);
                        }
                        return;
                    }
                    ++i;
                }
            }
        }
    }

    private void addOracleOptionSection(Composite group) {
        Label urlLabel = new Label(group, 0);
        urlLabel.setText(Messages.getString("WizardPage2.31"));
        this.connectionModeCombox = new Combo(group, 8);
        this.connectionModeCombox.setLayoutData((Object)new GridData(768));
        this.connectionModeCombox.add("NORMAL");
        this.connectionModeCombox.add("SYSDBA");
        this.connectionModeCombox.add("SYSOPEA");
        this.connectionModeCombox.select(0);
        if (this.getOldConfig() != null) {
            if (this.getOldConfig().isConnectAsSYSDBA()) {
                this.connectionModeCombox.select(1);
            }
            if (this.getOldConfig().isConnectAsSYSOPER()) {
                this.connectionModeCombox.select(2);
            }
        }
        int width = group.getSize().x;
        group.pack();
        int height = group.getSize().y;
        group.setSize(width, height);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setDescription(MSG);
            if (this.searchDriverFlg) {
                DBConfigWizard wiz = (DBConfigWizard)this.getWizard();
                WizardPage1 page = (WizardPage1)wiz.getPreviousPage((IWizardPage)this);
                this.updateComboBox(page.classpathList);
                String driver = this.driverCombox.getText();
                if (DBType.getType(driver) == 1) {
                    if (this.connectionModeCombox == null) {
                        this.addOracleOptionSection((Composite)this.group);
                        this.resize();
                    }
                } else {
                    DBType.getType(driver);
                }
            }
        }
    }
}

