/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.dialogs;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import zigen.plugin.db.ImageCacher;
import zigen.plugin.db.core.ColumnLayout;
import zigen.plugin.db.ui.dialogs.DBConfigWizard;
import zigen.plugin.db.ui.dialogs.DefaultWizardPage;
import zigen.plugin.db.ui.dialogs.DriverSelectDialog;
import zigen.plugin.db.ui.dialogs.Messages;
import zigen.plugin.db.ui.dialogs.WizardPage2;
import zigen.plugin.db.ui.editors.event.TextSelectionListener;
import zigen.plugin.db.ui.util.WidgetUtil;

public class WizardPage1
extends DefaultWizardPage {
    ImageCacher ic = ImageCacher.getInstance();
    public static final String MSG = Messages.getString("WizardPage1.1");
    List classpathList = null;
    Text nameText;
    TableViewer tableViewer;
    Table table;
    Button addBtn;
    Button addBtn2;
    Button removeBtn;

    public WizardPage1(ISelection selection) {
        super(Messages.getString("WizardPage1.2"));
        this.setTitle(Messages.getString("WizardPage1.3"));
        this.setPageComplete(false);
    }

    private void modified() {
        String str = this.nameText.getText().trim();
        if (!"".equals(str) && this.classpathList.size() > 0) {
            super.updateStatus(null);
        } else if ("".equals(str)) {
            super.updateStatus(Messages.getString("WizardPage1.6"));
        } else if (this.classpathList.size() == 0) {
            super.updateStatus(Messages.getString("WizardPage1.7"));
        }
    }

    public void createControl(Composite parent) {
        Composite container = this.createDefaultComposite(parent);
        Group group = new Group(container, 0);
        group.setText(Messages.getString("WizardPage1.8"));
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new GridLayout(1, false));
        this.addDBNameSection((Composite)group);
        Group group2 = new Group(container, 0);
        group2.setText(Messages.getString("WizardPage1.9"));
        group2.setLayoutData((Object)new GridData(1808));
        group2.setLayout((Layout)new GridLayout(1, false));
        this.addDriverSection((Composite)group2);
        this.setControl((Control)container);
    }

    private void addDBNameSection(Composite group) {
        this.nameText = new Text(group, 2052);
        this.nameText.setLayoutData((Object)new GridData(768));
        this.nameText.addFocusListener((FocusListener)new TextSelectionListener());
        if (this.getOldConfig() != null) {
            this.nameText.setText(this.getOldConfig().getDbName());
        } else {
            this.nameText.setText(this.DEFAULT_NAME);
        }
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WizardPage1.this.modified();
            }
        });
    }

    private void addDriverSection(Composite group) {
        Composite tableComposite = new Composite(group, 0);
        GridData data = new GridData(1808);
        data.widthHint = 200;
        data.heightHint = 120;
        tableComposite.setLayoutData((Object)data);
        ColumnLayout columnLayout = new ColumnLayout();
        tableComposite.setLayout((Layout)columnLayout);
        this.table = new Table(tableComposite, 2820);
        this.tableViewer = new TableViewer(this.table);
        this.table = this.tableViewer.getTable();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(false);
        this.tableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection select = event.getSelection();
                if (select != null) {
                    WizardPage1.this.removeBtn.setEnabled(true);
                } else {
                    WizardPage1.this.removeBtn.setEnabled(false);
                }
            }
        });
        GridData gd = new GridData(1808);
        this.tableViewer.getControl().setLayoutData((Object)gd);
        GC gc = new GC((Drawable)this.getShell());
        gc.setFont(JFaceResources.getDialogFont());
        TableColumn column1 = new TableColumn(this.table, 0);
        String DISPLAY_TXT = "PATH";
        column1.setText(DISPLAY_TXT);
        int minWidth = this.computeMinimumColumnWidth(gc, DISPLAY_TXT);
        columnLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, minWidth, true));
        gc.dispose();
        if (this.getOldConfig() != null) {
            this.classpathList = new ArrayList();
            String[] list = this.getOldConfig().getClassPaths();
            int i = 0;
            while (i < list.length) {
                this.classpathList.add(list[i]);
                ++i;
            }
        } else {
            this.classpathList = new ArrayList();
        }
        this.tableViewer.setInput((Object)this.classpathList);
        Composite buttonComp = new Composite(group, 0);
        buttonComp.setLayout((Layout)new GridLayout(4, false));
        buttonComp.setLayoutData((Object)new GridData(768));
        this.addBtn = WidgetUtil.createButton(buttonComp, 8, Messages.getString("WizardPage1.11"), this.BUTTON_WIDTH, new GridData());
        this.addBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog openDialog = new FileDialog(WizardPage1.this.table.getShell(), 4096);
                String openFile = openDialog.open();
                if (openFile != null && !WizardPage1.this.classpathList.contains(openFile)) {
                    WizardPage1.this.classpathList.add(openFile);
                    WizardPage1.this.tableViewer.setInput((Object)WizardPage1.this.classpathList);
                    WizardPage1.this.columnsPack(WizardPage1.this.table);
                }
            }
        });
        this.addBtn2 = WidgetUtil.createButton(buttonComp, 8, Messages.getString("WizardPage1.12"), this.BUTTON_WIDTH, new GridData());
        this.addBtn2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog openDialog = new DirectoryDialog(WizardPage1.this.table.getShell(), 4096);
                String openFile = openDialog.open();
                if (openFile != null && !WizardPage1.this.classpathList.contains(openFile)) {
                    WizardPage1.this.classpathList.add(openFile);
                    WizardPage1.this.tableViewer.setInput((Object)WizardPage1.this.classpathList);
                    WizardPage1.this.columnsPack(WizardPage1.this.table);
                }
            }
        });
        this.removeBtn = WidgetUtil.createButton(buttonComp, 8, Messages.getString("WizardPage1.13"), this.BUTTON_WIDTH, new GridData());
        this.removeBtn.setEnabled(false);
        this.removeBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = WizardPage1.this.table.getSelectionIndex();
                if (selectionIndex >= 0) {
                    WizardPage1.this.table.remove(selectionIndex);
                    WizardPage1.this.classpathList.remove(selectionIndex);
                    WizardPage1.this.tableViewer.setInput((Object)WizardPage1.this.classpathList);
                }
            }
        });
        final Button registedBtn = WidgetUtil.createButton(buttonComp, 8, Messages.getString("WizardPage1.14"), this.BUTTON_WIDTH, new GridData());
        registedBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DriverSelectDialog dialog = new DriverSelectDialog(registedBtn.getShell());
                if (dialog.open() == 0) {
                    WizardPage1.this.classpathList.addAll(dialog.getTargetNames());
                    WizardPage1.this.tableViewer.setInput((Object)WizardPage1.this.classpathList);
                    WizardPage1.this.columnsPack(WizardPage1.this.table);
                }
            }
        });
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setDescription(MSG);
            DBConfigWizard wiz = (DBConfigWizard)this.getWizard();
            IWizardPage page = wiz.getNextPage((IWizardPage)this);
            if (page instanceof WizardPage2) {
                ((WizardPage2)page).searchDriverFlg = true;
            }
        }
    }

    protected class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected TableLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = "";
            switch (columnIndex) {
                case 0: {
                    result = (String)element;
                    break;
                }
            }
            return result;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof String) {
                File file = new File((String)element);
                if (file.exists()) {
                    if (file.isDirectory()) {
                        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
                    }
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
                }
                return WizardPage1.this.ic.getImage("warning.gif");
            }
            return null;
        }

        public Image getImage(Object obj) {
            return null;
        }
    }

    protected class TableContentProvider
    implements IStructuredContentProvider {
        protected TableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput != null) {
                WizardPage1.this.modified();
            }
        }

        public void dispose() {
        }
    }
}

