/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.actions;

import java.util.Iterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.ui.actions.Messages;
import zigen.plugin.db.ui.internal.Folder;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.internal.TreeLeaf;
import zigen.plugin.db.ui.jobs.LoadColumnsJob;

public class LoadColumnAction
extends Action
implements Runnable {
    TreeViewer viewer = null;

    public LoadColumnAction(TreeViewer viewer) {
        this.viewer = viewer;
        this.setText(Messages.getString("LoadColumnAction.0"));
        this.setEnabled(true);
    }

    public void run() {
        try {
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            Iterator iter = selection.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (!(element instanceof Folder)) continue;
                Folder folder = (Folder)element;
                IDBConfig config = folder.getDbConfig();
                if (!folder.getName().equalsIgnoreCase("TABLE")) continue;
                TreeLeaf[] ts = folder.getChildrens();
                ITable[] tables = new ITable[ts.length];
                System.arraycopy(ts, 0, tables, 0, ts.length);
                LoadColumnsJob job = new LoadColumnsJob(this.viewer, config, tables);
                job.setPriority(20);
                job.setUser(true);
                job.schedule();
            }
        }
        catch (Exception e) {
            DbPlugin.log(e);
        }
    }
}

