/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core.rule;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.DbPluginConstant;
import zigen.plugin.db.core.SQLFormatter;
import zigen.plugin.db.core.SQLUtil;
import zigen.plugin.db.core.StringUtil;
import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.core.TableConstraintColumn;
import zigen.plugin.db.core.TableFKColumn;
import zigen.plugin.db.core.TableIDXColumn;
import zigen.plugin.db.core.TablePKColumn;
import zigen.plugin.db.core.rule.AbstractSQLCreatorFactory;
import zigen.plugin.db.core.rule.ISQLCreatorFactory;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.ITable;

public class DefaultSQLCreatorFactory
extends AbstractSQLCreatorFactory
implements ISQLCreatorFactory {
    protected Column[] cols;
    protected TablePKColumn[] pks;
    protected String primaryKeyName = null;
    protected List fks;
    protected List cons;
    protected List uidxs;
    protected List nuidxs;
    protected boolean isVisibleSchemaName = true;

    public void setVisibleSchemaName(boolean b) {
        this.isVisibleSchemaName = b;
    }

    protected DefaultSQLCreatorFactory(ITable table) {
        this.setTable(table);
    }

    protected void setTable(ITable table) {
        if (table != null) {
            this.table = table;
            this.cols = table.getColumns();
            this.pks = table.getTablePKColumns();
            this.cons = this.convertTableConstraintColumn(table.getTableConstraintColumns());
            this.fks = this.convertTableFKColumn(table.getTableFKColumns());
            this.uidxs = this.convertTableIDXColumn(table.getTableUIDXColumns());
        }
    }

    public List convertTableIDXColumn(TableIDXColumn[] idxs) {
        if (idxs == null) {
            return null;
        }
        ArrayList<TableIDXColumn[]> result = new ArrayList<TableIDXColumn[]>();
        String temp = "";
        int i = 0;
        while (i < idxs.length) {
            TableIDXColumn idx = idxs[i];
            ArrayList<TableIDXColumn> list = new ArrayList<TableIDXColumn>();
            list.add(idx);
            temp = idx.getName();
            int k = i + 1;
            while (k < idxs.length) {
                TableIDXColumn _idx = idxs[k];
                if (!temp.equals(_idx.getName())) {
                    temp = _idx.getName();
                    result.add(list.toArray(new TableIDXColumn[0]));
                    break;
                }
                list.add(_idx);
                ++i;
                ++k;
            }
            if (i >= idxs.length - 1) {
                result.add(list.toArray(new TableIDXColumn[0]));
            }
            ++i;
        }
        return result;
    }

    public List convertTableConstraintColumn(TableConstraintColumn[] cons) {
        if (cons == null) {
            return null;
        }
        ArrayList<TableConstraintColumn[]> result = new ArrayList<TableConstraintColumn[]>();
        String temp = "";
        int i = 0;
        while (i < cons.length) {
            TableConstraintColumn con = cons[i];
            ArrayList<TableConstraintColumn> list = new ArrayList<TableConstraintColumn>();
            list.add(con);
            temp = con.getName();
            int k = i + 1;
            while (k < cons.length) {
                TableConstraintColumn _wk = cons[k];
                if (!temp.equals(_wk.getName())) {
                    temp = _wk.getName();
                    result.add(list.toArray(new TableConstraintColumn[0]));
                    break;
                }
                list.add(_wk);
                ++i;
                ++k;
            }
            if (i >= cons.length - 1) {
                result.add(list.toArray(new TableConstraintColumn[0]));
            }
            ++i;
        }
        return result;
    }

    public List convertTableFKColumn(TableFKColumn[] fks) {
        if (fks == null) {
            return null;
        }
        ArrayList<TableFKColumn[]> result = new ArrayList<TableFKColumn[]>();
        String temp = "";
        int i = 0;
        while (i < fks.length) {
            TableFKColumn fk = fks[i];
            ArrayList<TableFKColumn> list = new ArrayList<TableFKColumn>();
            list.add(fk);
            temp = fk.getName();
            int k = i + 1;
            while (k < fks.length) {
                TableFKColumn _fkc = fks[k];
                if (!temp.equals(_fkc.getName())) {
                    temp = _fkc.getName();
                    result.add(list.toArray(new TableFKColumn[0]));
                    break;
                }
                list.add(_fkc);
                ++i;
                ++k;
            }
            if (i >= fks.length - 1) {
                result.add(list.toArray(new TableFKColumn[0]));
            }
            ++i;
        }
        return result;
    }

    public String createDDL() {
        StringBuffer sb = new StringBuffer();
        String folderName = this.table.getFolderName();
        if ("VIEW".equals(folderName)) {
            sb.append(this.getCreateView());
        } else {
            sb.append(this.getCreateTableStr());
        }
        sb.append(this.getTableComment());
        sb.append(this.getColumnComment());
        return sb.toString();
    }

    protected String getCreateTableStr() {
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE TABLE ");
        if (this.isVisibleSchemaName) {
            sb.append(SQLUtil.encodeQuotation(this.table.getSqlTableName()));
        } else {
            sb.append(SQLUtil.encodeQuotation(this.table.getName()));
        }
        sb.append(DbPluginConstant.LINE_SEP);
        sb.append("(");
        sb.append(DbPluginConstant.LINE_SEP);
        sb.append(this.getColumnDefine());
        sb.append(this.getConstraints());
        sb.append(")");
        this.setDemiliter(sb);
        return sb.toString();
    }

    protected boolean hasPrimaryKey() {
        return this.pks != null && this.pks.length > 0;
    }

    protected boolean hasForeginKey() {
        return this.fks != null && this.fks.size() > 0;
    }

    protected boolean hasUniqueIndexKey() {
        return this.uidxs != null && this.uidxs.size() > 0;
    }

    protected String getColumnDefine() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.cols.length) {
            Column col = this.cols[i];
            TableColumn column = col.getColumn();
            if (i == this.cols.length - 1) {
                sb.append(this.getColumnLabel(column));
                if (column.isNotNull()) {
                    sb.append(" NOT NULL");
                }
                if (this.hasPrimaryKey() || this.hasForeginKey() || this.hasUniqueIndexKey()) {
                    sb.append(",");
                }
                sb.append(DbPluginConstant.LINE_SEP);
            } else {
                sb.append(this.getColumnLabel(column));
                if (column.isNotNull()) {
                    sb.append(" NOT NULL");
                }
                sb.append(",");
                sb.append(DbPluginConstant.LINE_SEP);
            }
            ++i;
        }
        return sb.toString();
    }

    protected String getColumnLabel(TableColumn column) {
        StringBuffer sb = new StringBuffer();
        sb.append("    ");
        sb.append(StringUtil.padding(column.getColumnName(), 28));
        String typeName = column.getTypeName().toUpperCase();
        sb.append(typeName);
        if (this.isVisibleColumnSize(typeName)) {
            if (column.getDecimalDigits() == 0) {
                sb.append("(" + column.getColumnSize() + ")");
            } else {
                sb.append("(" + column.getColumnSize() + "," + column.getDecimalDigits() + ")");
            }
        }
        return sb.toString();
    }

    protected String getConstraintPKStr() {
        StringBuffer sb = new StringBuffer();
        if (this.pks == null || this.pks.length == 0) {
            return null;
        }
        int i = 0;
        i = 0;
        while (i < this.pks.length) {
            TablePKColumn pkc = this.pks[i];
            if (i == 0) {
                this.primaryKeyName = pkc.getName();
                sb.append("CONSTRAINT ");
                sb.append(pkc.getName());
                sb.append(" PRIMARY KEY ");
                sb.append("(");
                sb.append(pkc.getColumnName());
            } else {
                sb.append(", " + pkc.getColumnName());
            }
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    protected String[] getConstraintFKStr() {
        if (this.fks == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        Iterator iter = this.fks.iterator();
        while (iter.hasNext()) {
            TableFKColumn[] _fks = (TableFKColumn[])iter.next();
            StringBuffer sb = new StringBuffer();
            StringBuffer sb2 = new StringBuffer();
            boolean cascade = false;
            int i = 0;
            while (i < _fks.length) {
                TableFKColumn column = _fks[i];
                cascade = column.isCasucade();
                if (i == 0) {
                    sb.append("CONSTRAINT ");
                    sb.append(column.getName());
                    sb.append(" FOREIGN KEY ");
                    sb.append("(");
                    sb.append(column.getColumnName());
                    sb2.append(" REFERENCES ");
                    if (this.isVisibleSchemaName && column.getPkSchema() != null) {
                        sb2.append(column.getPkSchema());
                        sb2.append(".");
                    } else if (this.table.getSchemaName() != null && !this.table.getSchema().getName().equalsIgnoreCase(column.getPkColumnName())) {
                        sb2.append(column.getPkSchema());
                        sb2.append(".");
                    }
                    sb2.append(column.getPkTableName());
                    sb2.append(" ");
                    sb2.append("(");
                    sb2.append(column.getPkColumnName());
                } else {
                    sb.append(", " + column.getColumnName());
                    sb2.append(", " + column.getColumnName());
                }
                ++i;
            }
            sb.append(")");
            sb2.append(")");
            if (cascade) {
                sb2.append(" ON DELETE CASCADE");
            }
            result.add(String.valueOf(sb.toString()) + sb2.toString());
        }
        return result.toArray(new String[0]);
    }

    protected String[] getConstraintOtherStr() {
        if (this.cons == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        String type = null;
        String paramater = null;
        Iterator iter = this.cons.iterator();
        while (iter.hasNext()) {
            TableConstraintColumn[] _cons = (TableConstraintColumn[])iter.next();
            StringBuffer sb = new StringBuffer();
            int i = 0;
            i = 0;
            while (i < _cons.length) {
                TableConstraintColumn column = _cons[i];
                if (i == 0) {
                    if (column.getColumnName() == null && !"".equals(column.getSearch_condition())) {
                        column.getName();
                        type = "CHECK";
                        if (column.getSearch_condition() != null) {
                            paramater = "(" + column.getSearch_condition().trim();
                        }
                        sb.append("CONSTRAINT ");
                        sb.append(column.getName());
                        sb.append(" ");
                        sb.append(type);
                        sb.append(paramater);
                        break;
                    }
                    column.getName();
                    type = column.isNonUnique() ? "NONUNIQUE" : "UNIQUE";
                    sb.append("CONSTRAINT ");
                    sb.append(column.getName());
                    sb.append(" ");
                    sb.append(type);
                    sb.append(" (");
                    sb.append(column.getColumnName());
                } else {
                    sb.append(", " + column.getColumnName());
                }
                ++i;
            }
            sb.append(")");
            result.add(sb.toString());
        }
        return result.toArray(new String[0]);
    }

    protected String[] getConstraintIDXStr() {
        if (this.uidxs == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        Iterator iter = this.uidxs.iterator();
        while (iter.hasNext()) {
            TableIDXColumn[] _idxs = (TableIDXColumn[])iter.next();
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < _idxs.length) {
                TableIDXColumn column = _idxs[i];
                if (column.getName().equals(this.primaryKeyName)) break;
                if (i == 0) {
                    sb.append("CONSTRAINT ");
                    sb.append(column.getName());
                    sb.append(" UNIQUE ");
                    sb.append("(");
                    sb.append(column.getColumnName());
                } else {
                    sb.append(", " + column.getColumnName());
                }
                if (i == _idxs.length - 1) {
                    sb.append(")");
                }
                ++i;
            }
            if (sb.length() == 0) continue;
            result.add(sb.toString());
        }
        return result.toArray(new String[0]);
    }

    protected String getConstraints() {
        int i;
        boolean hasIx;
        StringBuffer sb = new StringBuffer();
        String pks = this.getConstraintPKStr();
        String[] fks = this.getConstraintFKStr();
        String[] cons = this.getConstraintOtherStr();
        String[] idxs = this.getConstraintIDXStr();
        boolean bl = pks != null && pks.length() != 0;
        boolean hasFk = fks != null && fks.length != 0;
        boolean hasCs = cons != null && cons.length != 0;
        boolean bl2 = hasIx = idxs != null && idxs.length != 0;
        if (pks != null) {
            sb.append("    " + pks);
            if (hasFk || hasCs || hasIx) {
                sb.append(",");
            }
            sb.append(DbPluginConstant.LINE_SEP);
        }
        if (fks != null) {
            i = 0;
            while (i < fks.length) {
                if (i == fks.length - 1) {
                    sb.append("    " + fks[i]);
                    if (hasCs || hasIx) {
                        sb.append(",");
                    }
                } else {
                    sb.append("    " + fks[i] + ",");
                }
                sb.append(DbPluginConstant.LINE_SEP);
                ++i;
            }
        }
        if (cons != null) {
            i = 0;
            while (i < cons.length) {
                if (i == cons.length - 1) {
                    sb.append("    " + cons[i]);
                    if (hasIx) {
                        sb.append(",");
                    }
                } else {
                    sb.append("    " + cons[i] + ",");
                }
                sb.append(DbPluginConstant.LINE_SEP);
                ++i;
            }
        }
        if (idxs != null) {
            i = 0;
            while (i < idxs.length) {
                if (i == idxs.length - 1) {
                    sb.append("    " + idxs[i]);
                } else {
                    sb.append("    " + idxs[i] + ",");
                }
                sb.append(DbPluginConstant.LINE_SEP);
                ++i;
            }
        }
        return sb.toString();
    }

    public String createSelect(String condition, int limit) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT * FROM ");
        sb.append(this.table.getSqlTableName());
        if (condition != null && !"".equals(condition.trim())) {
            sb.append(" WHERE " + condition);
        }
        return sb.toString();
    }

    public boolean isSupportPager() {
        return false;
    }

    public String createSelectForPager(String _condition, int offset, int limit) {
        throw new UnsupportedOperationException("createCommentOnColumnDDL Method is not supported.");
    }

    public String createCountAll(String condition) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT COUNT(*) FROM ");
        sb.append(this.table.getSqlTableName());
        if (condition != null && !"".equals(condition.trim())) {
            sb.append(" WHERE " + condition);
        }
        return sb.toString();
    }

    public String createCountForQuery(String query) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT COUNT(*) FROM ( ");
        sb.append(DbPluginConstant.LINE_SEP);
        sb.append(query);
        sb.append(DbPluginConstant.LINE_SEP);
        sb.append(" ) TBL");
        return sb.toString();
    }

    public String VisibleColumnSizePattern() {
        return ".*CHAR|^VARCHAR.*|^NUMBER|^DECIMAL|.*INT.*|^FLOAT|^DOUBLE|^REAL|^TIMESTAMP|^TIME|.*VARYING";
    }

    public boolean isVisibleColumnSize(String typeName) {
        return typeName.toUpperCase().matches(this.VisibleColumnSizePattern());
    }

    public String[] getSupportColumnType() {
        return new String[]{"INT", "INTEGER", "DOUBLE", "FLOAT", "VARCHAR", "CHAR", "DECIMAL", "NUMERIC", "BOOLEAN", "BIT", "TINYINT", "SMALLINT", "BIGINT", "REAL", "BINATY", "VARBINATY", "LONGBINARY", "DATE", "TIME", "TIMESTAMP", "DATETIME", "OTHER", "OBJECT"};
    }

    public String getTableComment() {
        StringBuffer sb = new StringBuffer();
        if (this.table.getRemarks() != null && !"".equals(this.table.getRemarks())) {
            sb.append("COMMENT ON TABLE ");
            if (this.isVisibleSchemaName) {
                sb.append(SQLUtil.encodeQuotation(this.table.getSqlTableName()));
            } else {
                sb.append(SQLUtil.encodeQuotation(this.table.getName()));
            }
            sb.append(" IS ");
            sb.append("'");
            sb.append(this.table.getRemarks());
            sb.append("'");
            this.setDemiliter(sb);
        }
        return sb.toString();
    }

    public String getColumnComment() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.cols.length) {
            Column col = this.cols[i];
            TableColumn tCol = col.getColumn();
            if (tCol.getRemarks() != null && !"".equals(tCol.getRemarks())) {
                sb.append("COMMENT ON COLUMN ");
                if (this.isVisibleSchemaName) {
                    sb.append(SQLUtil.encodeQuotation(this.table.getSqlTableName()));
                } else {
                    sb.append(SQLUtil.encodeQuotation(this.table.getName()));
                }
                sb.append(".");
                sb.append(tCol.getColumnName());
                sb.append(" IS ");
                sb.append("'");
                sb.append(tCol.getRemarks());
                sb.append("'");
                this.setDemiliter(sb);
            }
            ++i;
        }
        return sb.toString();
    }

    protected String getCreateView() {
        StringBuffer wk = new StringBuffer();
        try {
            boolean onPatch = DbPlugin.getDefault().getPreferenceStore().getBoolean("SQLEditorPreferencePage.FormatPatch");
            int type = DbPlugin.getDefault().getPreferenceStore().getInt("SQLFormatPreferencePage.UseFormatterType");
            wk.append("CREATE OR REPLACE VIEW ");
            if (this.isVisibleSchemaName) {
                wk.append(SQLUtil.encodeQuotation(this.table.getSqlTableName()));
            } else {
                wk.append(SQLUtil.encodeQuotation(this.table.getName()));
            }
            wk.append(DbPluginConstant.LINE_SEP);
            wk.append("(");
            int i = 0;
            while (i < this.cols.length) {
                Column col = this.cols[i];
                if (i > 0) {
                    wk.append(",");
                }
                wk.append(col.getName());
                wk.append(DbPluginConstant.LINE_SEP);
                ++i;
            }
            wk.append(")");
            wk.append(DbPluginConstant.LINE_SEP);
            wk.append("AS");
            wk.append(DbPluginConstant.LINE_SEP);
            wk.append(this.getViewDDL(this.table.getDbConfig(), this.table.getSchemaName(), this.table.getName()));
            StringBuffer sb = new StringBuffer();
            sb.append(SQLFormatter.format(wk.toString(), type, onPatch));
            this.setDemiliter(sb);
            return sb.toString();
        }
        catch (Exception e) {
            DbPlugin.log(e);
            return null;
        }
    }

    public boolean supportsRemarks() {
        return false;
    }

    public boolean supportsModifyColumnType() {
        return false;
    }

    public boolean supportsModifyColumnSize(String columnType) {
        return false;
    }

    public boolean supportsDropColumnCascadeConstraints() {
        return false;
    }

    public boolean supportsRollbackDDL() {
        return false;
    }

    public String createCreateIndexDDL(String indexName, Column[] columns, int indexType) {
        throw new UnsupportedOperationException("createCreateIndexDDL Method is not supported.");
    }

    public String createDropIndexDDL(String indexName) {
        throw new UnsupportedOperationException("createDropIndexDDL Method is not supported.");
    }

    public String createCreateConstraintCheckDDL(String constraintName, String check) {
        throw new UnsupportedOperationException("createCreateConstraintCheckDDL Method is not supported.");
    }

    public String createCreateConstraintFKDDL(String constraintName, Column[] columns, ITable refTable, Column[] refColumns, boolean onDeleteCascade) {
        throw new UnsupportedOperationException("createCreateConstraintFKDDL Method is not supported.");
    }

    public String createCreateConstraintPKDDL(String constraintName, Column[] columns) {
        throw new UnsupportedOperationException("createCreateConstraintPKDDL Method is not supported.");
    }

    public String createCreateConstraintUKDDL(String constraintName, Column[] columns) {
        throw new UnsupportedOperationException("createCreateConstraintUKDDL Method is not supported.");
    }

    public String createDropConstraintDDL(String constraintName, String type) {
        throw new UnsupportedOperationException("createDropConstraintDDL Method is not supported.");
    }

    protected String getViewDDL_SQL(String owner, String view) {
        throw new UnsupportedOperationException("getViewDDL_SQL Method is not supported.");
    }

    public String createCommentOnTableDDL(String commnets) {
        throw new UnsupportedOperationException("createCommentOnTableDDL Method is not supported.");
    }

    public String createCommentOnColumnDDL(Column column) {
        throw new UnsupportedOperationException("createCommentOnColumnDDL Method is not supported.");
    }

    public String createRenameTableDDL(String newTableName) {
        throw new UnsupportedOperationException("createRenameTableDDL Method is not supported.");
    }

    public String createRenameColumnDDL(Column from, Column to) {
        throw new UnsupportedOperationException("createRenameColumnDDL Method is not supported.");
    }

    public String[] createAddColumnDDL(Column column) {
        throw new UnsupportedOperationException("createAddColumnDDL Method is not supported.");
    }

    public String[] createModifyColumnDDL(Column from, Column to) {
        throw new UnsupportedOperationException("createModifyColumnDDL Method is not supported.");
    }

    public String[] createDropColumnDDL(Column column, boolean cascadeConstraints) {
        throw new UnsupportedOperationException("createDropColumnDDL Method is not supported.");
    }
}

