/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core.rule;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import zigen.plugin.db.core.DBType;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.rule.DefaultConstraintSearcherFactory;
import zigen.plugin.db.core.rule.IConstraintSearcherFactory;
import zigen.plugin.db.core.rule.mysql.MySQLConstraintSearcharFactory;
import zigen.plugin.db.core.rule.oracle.OracleConstraintSearcharFactory;

public abstract class AbstractConstraintSearcherFactory
implements IConstraintSearcherFactory {
    private static Map map = new HashMap();

    public static final String getIndexTypeName(int indexType) {
        switch (indexType) {
            case 0: {
                return "TABLE_INDEX_STATISTIC";
            }
            case 1: {
                return "TABLE_INDEX_CLSTERED";
            }
            case 2: {
                return "TABLE_INDEX_HASHED";
            }
            case 3: {
                return "TABLE_INDEX_OTHER";
            }
        }
        return "TABLE_INDEX_UNKNOWN";
    }

    public static IConstraintSearcherFactory getFactory(IDBConfig config) {
        return AbstractConstraintSearcherFactory.getFactory(config.getDriverName());
    }

    public static IConstraintSearcherFactory getFactory(DatabaseMetaData objMet) {
        try {
            return AbstractConstraintSearcherFactory.getFactory(objMet.getDriverName());
        }
        catch (SQLException sQLException) {
            throw new IllegalStateException("DriverName\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
        }
    }

    public static IConstraintSearcherFactory getFactory(String driverName) {
        IConstraintSearcherFactory factory = null;
        String key = driverName;
        if (map.containsKey(key)) {
            factory = (IConstraintSearcherFactory)map.get(key);
        } else {
            switch (DBType.getType(driverName)) {
                case 1: {
                    factory = new OracleConstraintSearcharFactory();
                    break;
                }
                case 2: {
                    factory = new MySQLConstraintSearcharFactory();
                    break;
                }
                default: {
                    factory = new DefaultConstraintSearcherFactory();
                }
            }
            map.put(key, factory);
        }
        return factory;
    }
}

