/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.StatementUtil;
import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.core.rule.AbstractMappingFactory;
import zigen.plugin.db.core.rule.IMappingFactory;
import zigen.plugin.db.ui.internal.ITable;

public class UpdateSQLInvoker {
    public static int invoke(IDBConfig config, ITable table, TableColumn[] updateColumns, Object[] updateItems, TableColumn[] uniqueColumns, Object[] uniqueItems) throws Exception {
        Connection con = Transaction.getInstance(config).getConnection();
        return UpdateSQLInvoker.invoke(con, table, updateColumns, updateItems, uniqueColumns, uniqueItems);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int invoke(Connection con, ITable table, TableColumn[] updateColumns, Object[] updateItems, TableColumn[] uniqueColumns, Object[] uniqueItems) throws Exception {
        String nullSymbol = DbPlugin.getDefault().getPreferenceStore().getString("PreferencePage.NullSymbol");
        StringBuffer sb = new StringBuffer();
        PreparedStatement pst = null;
        try {
            int n;
            try {
                IMappingFactory factory = AbstractMappingFactory.getFactory(table.getDbConfig());
                sb.append("UPDATE ");
                sb.append(table.getSqlTableName());
                int i = 0;
                while (i < updateColumns.length) {
                    if (i == 0) {
                        sb.append(" SET ");
                    } else {
                        sb.append(", ");
                    }
                    sb.append(String.valueOf(updateColumns[i].getColumnName()) + "= ? ");
                    ++i;
                }
                i = 0;
                while (i < uniqueColumns.length) {
                    if (i == 0) {
                        sb.append("WHERE ");
                        sb.append(uniqueColumns[i].getColumnName());
                        if (uniqueItems[i] == null || nullSymbol.equals(uniqueItems[i])) {
                            sb.append(" is null ");
                        } else {
                            sb.append(" = ? ");
                        }
                    } else {
                        sb.append("AND ");
                        sb.append(uniqueColumns[i].getColumnName());
                        if (uniqueItems[i] == null || nullSymbol.equals(uniqueItems[i])) {
                            sb.append(" is null ");
                        } else {
                            sb.append(" = ? ");
                        }
                    }
                    ++i;
                }
                pst = con.prepareStatement(sb.toString());
                int index = 0;
                int i2 = 0;
                while (i2 < updateItems.length) {
                    factory.setObject(pst, ++index, updateColumns[i2], updateItems[i2]);
                    ++i2;
                }
                i2 = 0;
                while (i2 < uniqueItems.length) {
                    if (uniqueItems[i2] != null && !nullSymbol.equals(uniqueItems[i2])) {
                        factory.setObject(pst, ++index, uniqueColumns[i2], uniqueItems[i2]);
                    }
                    ++i2;
                }
                int rowAffected = pst.executeUpdate();
                if (rowAffected == 0) {
                    DbPlugin.log("[UpdateSQLInvoker#invoke]" + sb.toString());
                }
                n = rowAffected;
                Object var13_18 = null;
            }
            catch (SQLException e) {
                DbPlugin.log(e);
                String msg = e.getLocalizedMessage();
                switch (table.getDbConfig().getDbType()) {
                    case 1: {
                        if (!msg.startsWith("ORA-00997:")) throw e;
                        StringBuffer s = new StringBuffer();
                        s.append("[LONG]\u30c7\u30fc\u30bf\u578b\u3092\u542b\u3080[PrimaryKey]\u306e\u7121\u3044\u30c6\u30fc\u30d6\u30eb\u306f\u66f4\u65b0\u3067\u304d\u307e\u305b\u3093\n");
                        s.append("\u30a8\u30e9\u30fc\uff1a" + e.getLocalizedMessage());
                        throw new IllegalArgumentException(s.toString());
                    }
                }
                throw e;
            }
            catch (Exception e) {
                throw e;
            }
            StatementUtil.close(pst);
            return n;
        }
        catch (Throwable throwable) {
            Object var13_19 = null;
            StatementUtil.close(pst);
            throw throwable;
        }
    }
}

