/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core;

import java.sql.Driver;
import java.util.HashMap;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.PluginClassLoader;

public class DriverManager {
    private static DriverManager _instance;
    private HashMap driverMap = new HashMap();

    private DriverManager() {
    }

    private String getKey(IDBConfig config) {
        String key = config.getJdbcType() == 2 ? config.getDriverName() : String.valueOf(config.getDbName()) + config.getDriverName();
        return key;
    }

    public void removeCach(IDBConfig config) {
        this.driverMap.remove(this.getKey(config));
    }

    public static synchronized DriverManager getInstance() {
        if (_instance == null) {
            _instance = new DriverManager();
        }
        return _instance;
    }

    public Driver getDriver(IDBConfig config) throws Exception {
        String key = this.getKey(config);
        if (this.driverMap.containsKey(key)) {
            return (Driver)this.driverMap.get(key);
        }
        Driver driver = this.getDriver(config.getDriverName(), config.getClassPaths());
        this.driverMap.put(key, driver);
        return driver;
    }

    private Driver getDriver(String driverName, String[] classpaths) throws Exception {
        Class<?> driverClass = null;
        PluginClassLoader loader = PluginClassLoader.getClassLoader(classpaths, this.getClass().getClassLoader());
        try {
            driverClass = loader.loadClass(driverName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            driverClass = PluginClassLoader.getSystemClassLoader().loadClass(driverName);
        }
        return (Driver)driverClass.newInstance();
    }
}

