package zigen.plugin.db.ui.views;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.internal.OracleColumn;
import zigen.plugin.db.ui.internal.OracleSequence;
import zigen.plugin.db.ui.internal.OracleSource;
import zigen.plugin.db.ui.internal.Schema;
import zigen.plugin.db.ui.internal.Synonym;

public class TreeViewTableFilter extends ViewerFilter {

	protected String text;

	protected boolean schema;

	protected boolean table;

	protected boolean column;

	public TreeViewTableFilter(String text, boolean schema, boolean table, boolean column) {
		this.text = text.toLowerCase();
		this.schema = schema;
		this.table = table;
		this.column = column;
	}

	public boolean select(Viewer viewer, Object parent, Object node) {

		if (text != null && !"".equals(text)) { //$NON-NLS-1$

			if (schema && table && column) {
				return filterSchema(node) && filterTable(node) && filterColumn(node);

			} else if (schema && table && !column) {
				return filterSchema(node) && filterTable(node);

			} else if (schema && !table && column) {
				return filterSchema(node) && filterColumn(node);

			} else if (!schema && table && column) {
				return filterTable(node) && filterColumn(node);

			} else if (schema && !table && !column) {
				return filterSchema(node);

			} else if (!schema && table && !column) {
				return filterTable(node);

			} else if (!schema && !table && column) {
				return filterColumn(node);
			} else {

				return true;
			}

		} else {
			return true;
		}

	}

	private boolean filterSchema(Object element) {
		if (element instanceof Schema) {
			Schema schema = (Schema) element;

			if (schema.getName().toLowerCase().indexOf(text) >= 0) {
				return true;

			} else {
				return false;

			}

		} else {
			return true;
		}
	}

	private boolean filterTable(Object element) {
		if (element instanceof ITable) {
			ITable table = (ITable) element;

			if (table.getName().toLowerCase().indexOf(text) >= 0) {
				return true;

			} else if (table.getRemarks() != null && table.getRemarks().toLowerCase().indexOf(text) >= 0) {
				return true;

			} else {
				return false;

			}

		} else if (element instanceof Synonym) {
			Synonym synonym = (Synonym) element;
			if (synonym.getName().toLowerCase().indexOf(text) >= 0) {
				return true;

			} else if (synonym.getRemarks() != null && synonym.getRemarks().toLowerCase().indexOf(text) >= 0) {
				return true;

			} else {
				return false;

			}

		} else if (element instanceof OracleSequence) {
			OracleSequence seq = (OracleSequence) element;

			if (seq.getName().toLowerCase().indexOf(text) >= 0) {
				return true;

			} else {
				return false;

			}

		} else if (element instanceof OracleSource) {
			OracleSource source = (OracleSource) element;

			if (source.getName().toLowerCase().indexOf(text) >= 0) {
				return true;

			} else {
				return false;

			}
		} else {
			return true;
		}
	}

	private boolean filterColumn(Object element) {
		if (element instanceof Column) {
			Column col = (Column) element;

			if (col.getName().toLowerCase().indexOf(text) >= 0) {
				return true;

			} else if (col.getColumn().getRemarks() != null && col.getColumn().getRemarks().toLowerCase().indexOf(text) >= 0) {
				return true;

			} else {
				return false;

			}
		} else if (element instanceof OracleColumn) {
			OracleColumn col = (OracleColumn) element;

			if (col.getName().toLowerCase().indexOf(text) >= 0) {
				return true;

			} else if (col.getColumn().getRemarks() != null && col.getColumn().getRemarks().toLowerCase().indexOf(text) >= 0) {
				return true;

			} else {
				return false;

			}

		} else {
			return true;
		}
	}

}
