package zigen.plugin.db.ui.jobs;

import java.sql.Connection;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.TreeViewer;

import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.ext.oracle.internal.OracleSequenceInfo;
import zigen.plugin.db.ext.oracle.internal.OracleSequenceSearcher;
import zigen.plugin.db.ui.internal.Folder;
import zigen.plugin.db.ui.internal.OracleSequence;
import zigen.plugin.db.ui.internal.Schema;

public class OracleSequeceSearchJob extends AbstractJob {

	private TreeViewer viewer;

	private Folder folder;

	public OracleSequeceSearchJob(TreeViewer viewer, Folder folder) {
		super(Messages.getString("OracleSequeceSearchJob.0")); //$NON-NLS-1$
		this.viewer = viewer;
		this.folder = folder;
	}

	protected IStatus run(IProgressMonitor monitor) {
		try {
			start();

			Connection con = Transaction.getInstance(folder.getDbConfig()).getConnection();
			if (monitor.isCanceled()) {
				return Status.CANCEL_STATUS;
			}

			folder.removeChildAll(); // qm[hSč폜
			showResults(new RefreshTreeNodeAction(viewer, folder)); // ĕ`

			Schema schema = (Schema) folder.getParent();
			String owner = schema.getName();
			OracleSequenceInfo[] infos = OracleSequenceSearcher.execute(con, owner);
			addSequences(con, folder, infos);

			folder.setExpanded(true);
			showResults(new RefreshTreeNodeAction(viewer, folder, RefreshTreeNodeAction.MODE_NOTHING)); // ĕ`

		} catch (Exception e) {
			folder.setExpanded(false);
			showErrorMessage(Messages.getString("OracleSequeceSearchJob.1"), e); //$NON-NLS-1$

		} finally {
			stop();
		}
		return Status.OK_STATUS;
	}

	/**
	 * \[XvftH_zɒǉ
	 * 
	 * @param con
	 * @param folder
	 * @param infos
	 * @throws Exception
	 */
	private void addSequences(Connection con, Folder folder, OracleSequenceInfo[] infos) throws Exception {
		for (int i = 0; i < infos.length; i++) {
			OracleSequence seq = new OracleSequence();
			seq.setOracleSequenceInfo(infos[i]);
			folder.addChild(seq);
		}
	}
}
