package zigen.plugin.db.ui.editors.sql;

import java.sql.Connection;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.MatchingCharacterPainter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.EditorPart;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.ConnectionManager;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.SQLInvoker;
import zigen.plugin.db.ext.oracle.internal.OracleSourceDetailInfo;
import zigen.plugin.db.ext.oracle.internal.OracleSourceErrorInfo;
import zigen.plugin.db.ext.oracle.internal.OracleSourceErrorSearcher;
import zigen.plugin.db.preference.SQLEditorPreferencePage;
import zigen.plugin.db.ui.actions.GlobalAction;
import zigen.plugin.db.ui.util.LineNumberRulerColumnUtil;
import zigen.plugin.db.ui.util.StyledTextUtil;
import zigen.plugin.db.ui.views.internal.ColorManager;
import zigen.plugin.db.ui.views.internal.PLSQLCodeConfiguration;
import zigen.plugin.db.ui.views.internal.PLSQLDocument;
import zigen.plugin.db.ui.views.internal.PLSQLSourceViewer;
import zigen.plugin.db.ui.views.internal.SQLCharacterPairMatcher;

public class SourceEditor extends EditorPart implements IPropertyChangeListener {

	public static final String ID = "zigen.plugin.db.ui.editors.sql.SourceEditor"; //$NON-NLS-1$

	protected IDBConfig config;

	protected PLSQLSourceViewer sourceViewer;

	private OracleSourceDetailInfo sourceDetailInfo;

	private OracleSourceErrorInfo sourceErrorInfo;

	protected LineNumberRulerColumn rulerCol;

	protected PLSQLCodeConfiguration sqlConfiguration;

	protected ColorManager colorManager = new ColorManager();

	protected IPreferenceStore store;

	protected boolean dirty = false;

	protected Text errorText;

	protected SashForm sash;

	class DocumentListener implements IDocumentListener {
		public DocumentListener() {
		}

		public void documentAboutToBeChanged(DocumentEvent event) {
		}

		public void documentChanged(DocumentEvent event) {
			setDirty(true);
		}
	}

	public SourceEditor() {
		colorManager = new ColorManager();
		sqlConfiguration = new PLSQLCodeConfiguration(colorManager);
		this.store = DbPlugin.getDefault().getPreferenceStore();
		this.store.addPropertyChangeListener(this);
	}

	public void createPartControl(Composite parent) {
		// this.composite = parent;
		sash = new SashForm(parent, SWT.VERTICAL | SWT.NONE);
		CompositeRuler ruler = new CompositeRuler();
		LineNumberRulerColumn rulerCol = new LineNumberRulerColumn();
		LineNumberRulerColumnUtil.changeColor(colorManager, rulerCol);
		ruler.addDecorator(0, rulerCol);
		// sourceViewer = new PLSQLSourceViewer(sash, ruler, SWT.MULTI |
		// SWT.H_SCROLL | SWT.V_SCROLL | SWT.BORDER);
		sourceViewer = new PLSQLSourceViewer(sash, ruler, null, false, SWT.MULTI | SWT.H_SCROLL | SWT.V_SCROLL | SWT.BORDER);

		initializeViewerFont(sourceViewer);

		sourceViewer.configure(sqlConfiguration);

		PLSQLDocument doc = new PLSQLDocument();

		IDocumentListener documentListener = new DocumentListener();

		// DosumentListenero^
		doc.addDocumentListener(documentListener);

		sourceViewer.setDocument(doc);
		sourceViewer.getDocument().set(sourceDetailInfo.getText());

		ITextViewerExtension2 extension = (ITextViewerExtension2) sourceViewer;
		MatchingCharacterPainter painter = new MatchingCharacterPainter(sourceViewer, new SQLCharacterPairMatcher());
		painter.setColor(colorManager.getColor(SQLEditorPreferencePage.P_COLOR_MATCHING));
		extension.addPainter(painter);

		// ύXʒm
		setDirty(false);

		errorText = new Text(sash, SWT.MULTI);
		errorText.setEditable(false);
		Color white = Display.getCurrent().getSystemColor(SWT.COLOR_WHITE);
		Color red = Display.getCurrent().getSystemColor(SWT.COLOR_RED);
		errorText.setBackground(white);
		errorText.setForeground(red);

		setErrorMessage();

		hookContextMenu();
	}

	private void setErrorMessage() {
		if (sourceErrorInfo != null) {
			errorText.setText(sourceErrorInfo.getErrorText());
			sash.setWeights(new int[] {
					95,
					5
			});
		} else {
			errorText.setText(""); //$NON-NLS-1$
			sash.setWeights(new int[] {
					100,
					0
			});
		}
	}

	/**
	 * |bvAbvj[쐬\bh
	 */
	private void hookContextMenu() {
		MenuManager menuMgr = new MenuManager("#PopupMenu"); //$NON-NLS-1$
		menuMgr.setRemoveAllWhenShown(true);
		menuMgr.addMenuListener(new IMenuListener() {
			public void menuAboutToShow(IMenuManager manager) {
				getContributor().fillContextMenu(manager);
			}
		});
		StyledText text = sourceViewer.getTextWidget();
		Menu menu = menuMgr.createContextMenu(text);
		text.setMenu(menu);

		getSite().registerContextMenu(menuMgr, sourceViewer);
	}

	protected void setGlobalAction() {
		IActionBars actionbars = getEditorSite().getActionBars();
		actionbars.setGlobalActionHandler(ActionFactory.UNDO.getId(), new GlobalAction(sourceViewer, ITextOperationTarget.UNDO));
		actionbars.setGlobalActionHandler(ActionFactory.REDO.getId(), new GlobalAction(sourceViewer, ITextOperationTarget.REDO));
		actionbars.setGlobalActionHandler(ActionFactory.DELETE.getId(), new GlobalAction(sourceViewer, ITextOperationTarget.DELETE));
		actionbars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), new GlobalAction(sourceViewer, ITextOperationTarget.SELECT_ALL));
		actionbars.setGlobalActionHandler(ActionFactory.COPY.getId(), new GlobalAction(sourceViewer, ITextOperationTarget.COPY));
		actionbars.setGlobalActionHandler(ActionFactory.PASTE.getId(), new GlobalAction(sourceViewer, ITextOperationTarget.PASTE));
		actionbars.setGlobalActionHandler(ActionFactory.CUT.getId(), new GlobalAction(sourceViewer, ITextOperationTarget.CUT));
	}

	public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
		try {
			setSite(site);
			setInput(editorInput);

			if (editorInput instanceof SourceEditorInput) {
				SourceEditorInput input = (SourceEditorInput) editorInput;

				this.sourceDetailInfo = input.getSourceDetailInfo();
				this.sourceErrorInfo = input.getSourceErrorInfo();

				config = input.getConfig();
				setPartName(input.getName());
			}

		} catch (Exception e) {
			DbPlugin.getDefault().showErrorDialog(e);
		}
	}

	protected void initializeViewerFont(ISourceViewer viewer) {
		StyledText styledText = viewer.getTextWidget();
		styledText.setFont(DbPlugin.getDefaultFont());
	}

	public void propertyChange(PropertyChangeEvent event) {
		if (sqlConfiguration != null && sourceViewer != null) {
			sqlConfiguration.updatePreferences();
			StyledTextUtil.changeColor(colorManager, sourceViewer.getTextWidget());
			// LineNumberRulerColumnUtil.changeColor(colorManager, rulerCol);
			sourceViewer.invalidateTextPresentation();// eLXgGfB^ĕ`
		}
	}

	public void doSave(IProgressMonitor monitor) {

		Connection con = null;
		try {

			ISelection selection = sourceViewer.getSelection();

			con = ConnectionManager.getConnection(config);

			// sR[h\nłȂƁAPLS-00103邽߁Au
			String sql = sourceViewer.getDocument().get();
			sql = sql.replaceAll("\r", "\n"); //$NON-NLS-1$ //$NON-NLS-2$

			SQLInvoker.execute(con, sql);

			String owner = sourceDetailInfo.getOwner();
			String type = sourceDetailInfo.getType();
			String name = sourceDetailInfo.getName();

			// \[XĎ擾ꍇ͈ȉ̃\bh
			// sourceDetailInfo = OracleSourceDetailSearcher.execute(con, owner,
			// name, type);
			sourceErrorInfo = OracleSourceErrorSearcher.execute(con, owner, name, type);
			// 擾\[XĐݒ
			// sourceViewer.getDocument().set(sourceDetailInfo.getText());
			// ۑÖʒuɈړ
			// sourceViewer.setSelection(selection, true);

			setErrorMessage();

			// ύXʒm(OFF)
			setDirty(false);

		} catch (Exception e) {
			DbPlugin.getDefault().showErrorDialog(e);
		} finally {
			ConnectionManager.closeConnection(con);
		}
	}

	public void doSaveAs() {
	}

	public boolean isDirty() {
		return dirty;
	}

	protected void setDirty(boolean value) {
		dirty = value;
		firePropertyChange(PROP_DIRTY);
	}

	public boolean isSaveAsAllowed() {
		return true;
	}

	public void setFocus() {
		setGlobalAction();
	}

	public void dispose() {
		super.dispose();
		colorManager.dispose();
		DbPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this);
	}

	/**
	 * Contributor̎擾
	 * 
	 * @return
	 */
	private SourceEditorContributor getContributor() {
		IEditorActionBarContributor contributor = getEditorSite().getActionBarContributor();
		if (contributor instanceof SourceEditorContributor) {
			return (SourceEditorContributor) contributor;
		} else {
			return null;
		}
	}

}
