package zigen.plugin.db.ui.editors.internal.invoker;

import zigen.plugin.db.core.rule.ISQLCreatorFactory;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.ITable;

public class DropColumnInvoker extends AbstractSQLInvoker {

	private static String TITLE = Messages.getString("DropColumnInvoker.0"); //$NON-NLS-1$

	private Column column;

	private boolean cascadeConstraints;

	public DropColumnInvoker(ITable table, Column column, boolean cascadeConstraints) {
		super(TITLE, table);
		this.column = column;
		this.cascadeConstraints = cascadeConstraints;
	}

	public String[] createSQL(ISQLCreatorFactory factory, ITable table) {
		String[] sqls = factory.createDropColumnDDL(column, cascadeConstraints);
		return sqls;
	}

}