package zigen.plugin.db.ui.editors.internal.invoker;

import java.util.ArrayList;
import java.util.List;

import zigen.plugin.db.core.rule.ISQLCreatorFactory;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.ITable;

public class AddColumnInvoker extends AbstractSQLInvoker {

	private static String TITLE = Messages.getString("AddColumnInvoker.0"); //$NON-NLS-1$

	private Column column;

	public AddColumnInvoker(ITable table, Column column) {
		super(TITLE, table);
		this.column = column;
	}

	public String[] createSQL(ISQLCreatorFactory factory, ITable table) {
		List list = new ArrayList();

		String[] sqls = factory.createAddColumnDDL(column);
		for (int i = 0; i < sqls.length; i++) {
			list.add(sqls[i]);
		}

		// JRg̐ݒ
		list.add(factory.createCommentOnColumnDDL(column));

		return (String[]) list.toArray(new String[0]);
	}

}